/*
 *      Tag and audio information retrieval.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
 * http://www.gnu.org/copyleft/gpl.html .
 *
 */

/* $Id: gmi.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__GETINFO_H__
#define	__GETINFO_H__

#ifdef	GMI_EXPORTS
#define	GMIAPI	__declspec(dllexport)
#else
#define	GMIAPI
#endif

#ifdef	__cplusplus
extern "C" {
#endif/*__cplusplus*/

#include <pmplib/pmp.h>

/**
 * \addtogroup gmi
 * @{
 */

enum {
	GMIF_NONE			= 0x00000000,
	GMIF_TAG			= 0x00000001,
	GMIF_STRIP_ARTIST	= 0x00000010,
	GMIF_GENRE			= 0x00010000,
	GMIF_ARTIST			= 0x00020000,
	GMIF_ALBUM			= 0x00040000,
	GMIF_TITLE			= 0x00080000,
	GMIF_NUMBER			= 0x00100000,
	GMIF_PARSEMASK		= 0x00FF0000,
};

#define	media_info_t	pmp_music_record_t
#define	gmi_finish		pmplib_record_finish

GMIAPI int gmi_get(
	media_info_t* info,
	const ucs2char_t *filename,
	const ucs2char_t* path_to_music,
	int flag,
	const char *charset,
	ucs2char_t **strip_words,
	int num_strip_words
	);

/** @} */

#ifdef	__cplusplus
}
#endif/*__cplusplus*/

#endif/*__GETINFO_H__*/
