/*
 *      UCS-2 string library (char_trait<ucs2char_t> implementation).
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: ucs2string.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__UCS2STRING_H__
#define	__UCS2STRING_H__

#include <ucs2char.h>
#include <string>

struct ucs2char_traits
{
	typedef ucs2char_t					char_type;
	typedef int							int_type;
	typedef std::streamoff				off_type;
	typedef std::fpos<std::mbstate_t>	pos_type;
	typedef std::mbstate_t				state_type;

	static void assign(char_type& __cl, const char_type& __cr)
	{
		__cl = __cr;
	}

	static bool eq(const char_type& __cl, const char_type& __cr)
	{
		return __cl == __cr;
	}

	static bool lt(const char_type& __cl, const char_type& __cr)
	{
		return __cl < __cr;
	}

	static int compare(const char_type* __s1, const char_type* __s2, size_t __n)
	{
		return ucs2memcmp(__s1, __s2, __n);
	}

	static size_t length(const char_type* __s)
	{
		return ucs2len(__s);
	}

	static const char_type* find(const char_type* __s, size_t __n, const char_type& __a)
	{
		return ucs2memchr(__s, __a, __n);
	}

	static char_type* move(char_type* __s1, const char_type* __s2, size_t __n)
	{
		return ucs2memmove(__s1, __s2, __n);
	}

	static char_type* copy(char_type* __s1, const char_type* __s2, size_t __n)
	{
		return ucs2memcpy(__s1, __s2, __n);
	}
	
	static char_type* assign(char_type* __s, size_t __n, char_type __a)
	{
		return ucs2memset(__s, __a, __n);
	}
	
	static char_type to_char_type(const int_type& __c)
	{
		return char_type(__c);
	}
	
	static int_type to_int_type(const char_type& __c)
	{
		return int_type(__c);
	}

	static bool eq_int_type(const int_type& __c1, const int_type& __c2)
	{
		return __c1 == __c2;
	}

    static int_type eof()
	{
		return static_cast<int_type>(0xFFFF);
	}

	static int_type not_eof(const int_type& __c)
    {
		return eq_int_type(__c, eof()) ? 0 : __c;
	}
};

typedef std::basic_string<ucs2char_t, ucs2char_traits, std::allocator<ucs2char_t> > ucs2string;

#endif/*__UCS2STRING_H__*/
