/*
 *      Low-level library for db.dat.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: dat.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__IP3DB_DAT_H__
#define	__IP3DB_DAT_H__

typedef struct {
	int				num_fields;
	ip3db_variant_t	*fields;
	uint32_t		offset;
} dat_entry_t;

typedef struct {
	uint32_t		num_entries;
	dat_entry_t*	entries;
} dat_list_t;

struct tag_sort_index_t; typedef struct tag_sort_index_t sort_index_t;

struct tag_dat_t {
	dat_list_t		objects;
	dat_list_t		musics;
	dat_list_t		references;
	sort_index_t*	objects_uidmap;
};

dat_t* dat_new();
void dat_finish(dat_t* dat);
int dat_read(dat_t* dat, const dic_t* dic, FILE *fpi);
int dat_write(dat_t* dat, dic_t* dic, FILE *fpo);
void dat_dump(dat_t* dat, const dic_t* dic, FILE *fp);
void dat_set(dat_t* dat, dic_t* dic, const ip3db_music_record_t* records, int num_records, ip3db_playlist_t* playlists, int num_playlists);

#endif/*__IP3DB_DAT_H__*/
