/**********************************************************************
 *
 * Filename:    crc.h
 * 
 * Description: A header file describing the various CRC standards.
 *
 * Notes:       
 *
 * 
 * Copyright (c) 2000 by Michael Barr.  This software is placed into
 * the public domain and may be used for any purpose.  However, this
 * notice must not be changed or removed and no warranty is either
 * expressed or implied by its publication or distribution.
 **********************************************************************/

#ifndef _crc_h
#define _crc_h


/*
 * Select the CRC standard from the list that follows.
 */
#define CRC_H10DB	/* CRC-32 for H10 database. */


#if defined(CRC_CCITT)

typedef unsigned short  crc;

#define CRC_NAME			"CRC-CCITT"
#define POLYNOMIAL			0x1021
#define INITIAL_REMAINDER	0xFFFF
#define FINAL_XOR_VALUE		0x0000
#define REFLECT_DATA		0
#define REFLECT_REMAINDER	0
#define CHECK_VALUE			0x29B1

#elif defined(CRC16)

typedef unsigned short  crc;

#define CRC_NAME			"CRC-16"
#define POLYNOMIAL			0x8005
#define INITIAL_REMAINDER	0x0000
#define FINAL_XOR_VALUE		0x0000
#define REFLECT_DATA		1
#define REFLECT_REMAINDER	1
#define CHECK_VALUE			0xBB3D

#elif defined(CRC32)

typedef unsigned long  crc;

#define CRC_NAME			"CRC-32"
#define POLYNOMIAL			0x04C11DB7
#define INITIAL_REMAINDER	0xFFFFFFFF
#define FINAL_XOR_VALUE		0xFFFFFFFF
#define REFLECT_DATA		1
#define REFLECT_REMAINDER	1
#define CHECK_VALUE			0xCBF43926

/* The below was added for CRC calculation that satisfies H10 spec. */
#elif defined(CRC_H10DB)

typedef uint32_t crc;

#define CRC_NAME			"CRC-32 (H10)"
#define POLYNOMIAL			0x04C11DB7
#define INITIAL_REMAINDER	0x00000000
#define FINAL_XOR_VALUE		0x00000000
#define REFLECT_DATA		1
#define REFLECT_REMAINDER	1
#define CHECK_VALUE			0x2DFD2D88
/* End of modification. */

#else

#error "One of CRC_CCITT, CRC16, CRC32, or CRC_H10DB must be #define'd."

#endif


void  crcInit(void);
crc   crcSlow(unsigned char const message[], int nBytes);
crc   crcFast(unsigned char const message[], int nBytes);


#endif /* _crc_h */
