/*
 *      Low level interface for idx.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: idx.c 328 2007-02-10 17:50:11Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/
#ifdef	HAVE_STRING_H
#include <string.h>
#endif/*HAVE_STRING_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>
#include <pmplib/pmp.h>

#include "serialize.h"
#include "pp1db.h"

void idx_init(idx_t* elem)
{
	memset(elem, 0, sizeof(*elem));
}

size_t idx_serialize(uint8_t* block, idx_t* elem, int is_storing)
{
	uint8_t* p = block;
	p += serialize_uint32le(p, &elem->status, is_storing);
	p += serialize_uint32le(p, &elem->index, is_storing);
	p += serialize_uint32le(p, &elem->check_value, is_storing);
	return (size_t)(p-block);
}

void idx_dump(const idx_t* elem, FILE *fp)
{
	fprintf(fp, "  inactive: %d\n", elem->status);
	fprintf(fp, "  index: %d\n", elem->index);
	fprintf(fp, "  check_value: 0x%08X\n", elem->check_value);
}

void idx_repr(const idx_t* elem, FILE *fp)
{
	fprintf(fp, "inactive: %d, ", elem->status);
	fprintf(fp, "check_value: 0x%08X", elem->check_value);
}
