/*
 *      MEDION MDJuke440 specific routines and header templates.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: model_medion_mdjuke440.c 342 2007-02-11 18:11:43Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>
#include <pmplib/filepath.h>

#include "serialize.h"
#include "util.h"
#include "pp1db.h"
#include "hdr_template.h"

enum {
	PP1DB_DATFIELD_UNKNOWN2 = 0,// @0:	(INT)	
	PP1DB_DATFIELD_PATHNAME,	// @1:	(STR)	
	PP1DB_DATFIELD_FILENAME,	// @2:	(STR)	
	PP1DB_DATFIELD_FORMAT,		// @3:	(INT)
	PP1DB_DATFIELD_BITRATE,		// @4:	(INT)
	PP1DB_DATFIELD_ARTIST,		// @5:	(STR)
	PP1DB_DATFIELD_ALBUM,		// @6:	(STR)
	PP1DB_DATFIELD_GENRE,		// @7:	(STR)
	PP1DB_DATFIELD_TITLE,		// @8:	(STR)
	PP1DB_DATFIELD_TRACKNUMBER,	// @9:	(INT)
	PP1DB_DATFIELD_COMPOSER,	// @10: (STR)
};

void medion_mdjuke440_dat_repr(const dat_t* record, FILE *fp)
{
	fprintf(fp, "  inactive: %d\n", record->status);
	fprintf(fp, "  unknown1: %d\n", record->unknown1);
	fprintf(fp, "  unknown2: %d\n", record->fields[PP1DB_DATFIELD_UNKNOWN2].value.dword);
	fprints(fp, "  file_path: %s\n", record->fields[PP1DB_DATFIELD_PATHNAME].value.str);
	fprints(fp, "  file_name: %s\n", record->fields[PP1DB_DATFIELD_FILENAME].value.str);
	fprintf(fp, "  media_type: %d\n", record->fields[PP1DB_DATFIELD_FORMAT].value.dword);
	fprintf(fp, "  bitrate: %d\n", record->fields[PP1DB_DATFIELD_BITRATE].value.dword);
	fprints(fp, "  artist: %s\n", record->fields[PP1DB_DATFIELD_ARTIST].value.str);
	fprints(fp, "  album: %s\n", record->fields[PP1DB_DATFIELD_ALBUM].value.str);
	fprints(fp, "  genre: %s\n", record->fields[PP1DB_DATFIELD_GENRE].value.str);
	fprints(fp, "  title: %s\n", record->fields[PP1DB_DATFIELD_TITLE].value.str);
	fprintf(fp, "  number: %d\n", record->fields[PP1DB_DATFIELD_TRACKNUMBER].value.dword);
	fprints(fp, "  composer: %s\n", record->fields[PP1DB_DATFIELD_COMPOSER].value.str);
}

int medion_mdjuke440_dat_set(dat_t* dst, const pmp_music_record_t* src, const ucs2char_t* path_to_root)
{
	static const ucs2char_t ucs2cs_unknown[] = {'0',0};

	// Set fields.
	dst->status = 0;
	dst->unknown1 = 0;
	dst->fields[PP1DB_DATFIELD_PATHNAME].value.str = ucs2dup(filepath_skiproot(src->filename, path_to_root));
	filepath_remove_filespec(dst->fields[PP1DB_DATFIELD_PATHNAME].value.str);
	filepath_addslash(dst->fields[PP1DB_DATFIELD_PATHNAME].value.str);
	filepath_encode(dst->fields[PP1DB_DATFIELD_PATHNAME].value.str);
	dst->fields[PP1DB_DATFIELD_FILENAME].value.str = ucs2dup(filepath_skippath(src->filename));
	dst->fields[PP1DB_DATFIELD_FORMAT].value.dword = 0;
	dst->fields[PP1DB_DATFIELD_BITRATE].value.dword = src->bitrate;

	dst->fields[PP1DB_DATFIELD_ARTIST].value.str = ucs2dup(src->artist ? src->artist : ucs2cs_unknown);
	dst->fields[PP1DB_DATFIELD_ALBUM].value.str = ucs2dup(src->album ? src->album : ucs2cs_unknown);
	dst->fields[PP1DB_DATFIELD_GENRE].value.str = ucs2dup(src->genre ? src->genre : ucs2cs_unknown);
	dst->fields[PP1DB_DATFIELD_TITLE].value.str = ucs2dup(src->title ? src->title : dst->fields[PP1DB_DATFIELD_FILENAME].value.str);
	dst->fields[PP1DB_DATFIELD_TRACKNUMBER].value.dword = src->track_number;
	dst->fields[PP1DB_DATFIELD_COMPOSER].value.str = ucs2dup(src->composer ? src->composer : ucs2cs_unknown);
	return 0;
}

int medion_mdjuke440_dat_get(pmp_music_record_t* dst, const dat_t* src, const ucs2char_t* path_to_root)
{
	static const ucs2char_t ucs2cs_mp3[] = {'.','m','p','3',0};
	static const ucs2char_t ucs2cs_wma[] = {'.','w','m','a',0};
	static const ucs2char_t ucs2cs_wav[] = {'.','w','a','v',0};
	size_t length = 0;

	length  = ucs2len(path_to_root);
	length += ucs2len(src->fields[PP1DB_DATFIELD_PATHNAME].value.str);
	length += ucs2len(src->fields[PP1DB_DATFIELD_FILENAME].value.str);
	length += 3;

	dst->filename = (ucs2char_t*)ucs2malloc(sizeof(ucs2char_t) * length);
	if (dst->filename) {
		filepath_combinepath(dst->filename, length, path_to_root, src->fields[PP1DB_DATFIELD_PATHNAME].value.str);
		ucs2cat(dst->filename, src->fields[PP1DB_DATFIELD_FILENAME].value.str);
		filepath_decode(dst->filename);
	}

	dst->bitrate = src->fields[PP1DB_DATFIELD_BITRATE].value.dword;

	dst->artist = ucs2dup(src->fields[PP1DB_DATFIELD_ARTIST].value.str);
	dst->album = ucs2dup(src->fields[PP1DB_DATFIELD_ALBUM].value.str);
	dst->genre = ucs2dup(src->fields[PP1DB_DATFIELD_GENRE].value.str);
	dst->title = ucs2dup(src->fields[PP1DB_DATFIELD_TITLE].value.str);

	// Set codec information according to the file extensions.
	if (filepath_hasext(dst->filename, ucs2cs_mp3)) {
		dst->codec = PMPCODEC_MPEGLAYER3;
	} else if (filepath_hasext(dst->filename, ucs2cs_wma)) {
		dst->codec = PMPCODEC_WMA;
	} else if (filepath_hasext(dst->filename, ucs2cs_wav)) {
		dst->codec = PMPCODEC_WAV;
	}

	dst->track_number = src->fields[PP1DB_DATFIELD_TRACKNUMBER].value.dword;
	dst->composer = ucs2dup(src->fields[PP1DB_DATFIELD_COMPOSER].value.str);

	return 0;
}




static fd_template_t hdrtmpl_fd_mdjuke440[] = {
	{0x0000F001, 2,   4, 0, 0, 1, 0, 0, "SYSTEM\\DATA\\PP5000_@DEV.IDX"},
	{0x0000F002, 1, 128, 0, 0, 1, 0, 0, "SYSTEM\\DATA\\PP5000_FPTH.IDX"},
	{0x0000F003, 1, 128, 0, 0, 1, 0, 0, "SYSTEM\\DATA\\PP5000_FNAM.IDX"},
	{0x0000F00A, 2,   4, 0, 0, 1, 0, 0, "SYSTEM\\DATA\\PP5000_FRMT.IDX"},
	{0x0000F005, 2,   4, 0, 0, 0, 0, 0, ""},
	{0x0000003C, 1,  40, 0, 0, 1, 0, 0, "SYSTEM\\DATA\\PP5000_TPE1.IDX"},
	{0x0000001C, 1,  40, 0, 0, 1, 0, 0, "SYSTEM\\DATA\\PP5000_TALB.IDX"},
	{0x0000001F, 1,  20, 0, 0, 1, 0, 0, "SYSTEM\\DATA\\PP5000_TCON.IDX"},
	{0x0000002E, 1,  40, 0, 0, 1, 0, 0, "SYSTEM\\DATA\\PP5000_TIT2.IDX"},
	{0x00000043, 2,   4, 0, 0, 1, 0, 0, "SYSTEM\\DATA\\PP5000_TRCK.IDX"},
	{0x0000001E, 1,  40, 0, 0, 1, 0, 0, "SYSTEM\\DATA\\PP5000_TCOM.IDX"},
	{0x00000000, 0,   0, 0, 0, 0, 0, 0, ""},
	{0x00000000, 0,   0, 0, 0, 0, 0, 0, ""},
	{0x00000000, 0,   0, 0, 0, 0, 0, 0, ""},
	{0x00000000, 0,   0, 0, 0, 0, 0, 0, ""},
	{0x00000000, 0,   0, 0, 0, 0, 0, 0, ""},
	{0x00000000, 0,   0, 0, 0, 0, 0, 0, ""},
	{0x00000000, 0,   0, 0, 0, 0, 0, 0, ""},
	{0x00000000, 0,   0, 0, 0, 0, 0, 0, ""},
	{0x00000000, 0,   0, 0, 0, 0, 0, 0, ""},
};

static uint32_t hdrtmpl_max_dat_field_size_mdjuke440[] =
	{8, 12, 268, 524, 528, 532, 612, 692, 732, 812, 816, 0, 0, 0, 0, 0, 0, 0, 0, 0};


/********** MEDION MDJUKE440 firmware 1.5.5 **********/
static hdr_template_t hdrtmpl_medion_mdjuke440 = {
	0, 0, "SYSTEM\\DATA\\PP5000.DAT", 0, "SYSTEM\\DATA\\PP5000.HDR", 0x00000380, 0, 0, 11,
	hdrtmpl_fd_mdjuke440,
	hdrtmpl_max_dat_field_size_mdjuke440,
	0, 0,
	{233052, 20, 5000, 1032, 0, medion_mdjuke440_dat_repr, medion_mdjuke440_dat_set, medion_mdjuke440_dat_get},
};
int hdr_init_medion_mdjuke440(hdr_t* hdr)
{
	return apply_template(hdr, &hdrtmpl_medion_mdjuke440);
}

