/*
 *  device.c:  Device routines for nwipe.
 *
 *  Copyright Darik Horn <dajhorn-dban@vanadac.com>.
 *  
 *  Modifications to original dwipe Copyright Andy Beverley <andy@andybev.com>
 *  
 *  This program is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU General Public License as published by the Free Software
 *  Foundation, version 2.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with
 *  this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 *  Ave, Cambridge, MA 02139, USA.
 *
 */

/* Why is this needed? Segfaults without it */
#include <netinet/in.h>

#include "nwipe.h"
#include "context.h"
#include "method.h"
#include "options.h"
#include "logging.h"

#include <parted/parted.h>
#include <parted/debug.h> 

static int disk_count = 0;

int nwipe_device_scan( nwipe_context_t** c )
{
	/**
	 * Scans the the filesystem for storage device names.
	 *
	 * @parameter device_names  A reference to a null array pointer.
	 * @modifies  device_names  Populates device_names with an array of strings.
	 * @returns                 The number of strings in the device_names array.
	 *
	 */

	PedDevice* dev = NULL;
        ped_device_probe_all();
	
	int dcount = 0;

        while ((dev = ped_device_get_next (dev))) {

	        if (!ped_device_open(dev))
                	break;

                /* New device, reallocate memory */
		c[dcount] = (nwipe_context_t *) malloc (sizeof(nwipe_context_t)); 

	        /* Check the allocation. */
        	if( ! c[dcount] )
        	{
                	nwipe_perror( errno, __FUNCTION__, "malloc" );
			nwipe_log( NWIPE_LOG_FATAL, "Unable to create the array of enumeration contexts." );
			return errno;
		}

		/* Zero the allocation. */
                memset( c[dcount] , 0, sizeof( nwipe_context_t ) );

                /* Get device information */
                c[dcount]->label = dev->model;
                c[dcount]->device_name = dev->path;
                c[dcount]->device_size = dev->length * dev->sector_size;
                               
		dcount++;

	}


	/* Return the number of devices that were found. */
	return dcount;

} /* nwipe_device_scan */

/* eof */
