/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.dom.DOMSource;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.soap.EnvelopeBuilder;
import org.jboss.ws.core.soap.HRefInlineHandler;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPBodyElementDoc;
import org.jboss.ws.core.soap.SOAPBodyElementMessage;
import org.jboss.ws.core.soap.SOAPBodyElementRpc;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.ws.core.soap.SOAPHeaderElementImpl;
import org.jboss.ws.core.soap.SOAPPartImpl;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EnvelopeBuilderDOM
implements EnvelopeBuilder {
    private static Logger log = Logger.getLogger(EnvelopeBuilderDOM.class);
    private SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
    private Style style;

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Style style) {
        this.style = style;
    }

    @Override
    public SOAPEnvelope build(SOAPMessage soapMessage, InputStream ins, boolean ignoreParseError) throws IOException, SOAPException {
        Element domEnv = null;
        try {
            InputSource inputSource = new InputSource(ins);
            inputSource.setEncoding(this.getEncoding(soapMessage));
            domEnv = DOMUtils.parse((InputSource)inputSource);
        }
        catch (IOException ex) {
            if (ignoreParseError) {
                return null;
            }
            log.error((Object)"Exception while building envelope", (Throwable)ex);
            QName faultCode = Constants.SOAP11_FAULT_CODE_CLIENT;
            throw new CommonSOAPFaultException(faultCode, ex.getMessage());
        }
        return this.build(soapMessage, domEnv);
    }

    @Override
    public SOAPEnvelope build(SOAPMessage soapMessage, Reader reader, boolean ignoreParseError) throws IOException, SOAPException {
        Element domEnv = null;
        try {
            InputSource inputSource = new InputSource(reader);
            inputSource.setEncoding(this.getEncoding(soapMessage));
            domEnv = DOMUtils.parse((InputSource)inputSource);
        }
        catch (IOException ex) {
            if (ignoreParseError) {
                return null;
            }
            QName faultCode = Constants.SOAP11_FAULT_CODE_CLIENT;
            throw new CommonSOAPFaultException(faultCode, ex.getMessage());
        }
        return this.build(soapMessage, domEnv);
    }

    private String getEncoding(SOAPMessage soapMessage) throws SOAPException {
        String encoding = (String)soapMessage.getProperty("javax.xml.soap.character-set-encoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    @Override
    public SOAPEnvelope build(SOAPMessage soapMessage, Element domEnv) throws SOAPException {
        SOAPPartImpl soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
        SOAPEnvelopeImpl soapEnv = new SOAPEnvelopeImpl(soapPart, (SOAPElementImpl)this.soapFactory.createElement(domEnv, false), false);
        DOMUtils.copyAttributes((Element)((Object)soapEnv), (Element)domEnv);
        NodeList envChildNodes = domEnv.getChildNodes();
        for (int i = 0; i < envChildNodes.getLength(); ++i) {
            Node child = envChildNodes.item(i);
            short childType = child.getNodeType();
            if (childType != 1) continue;
            String elName = child.getLocalName();
            if ("Header".equals(elName)) {
                this.buildSOAPHeader(soapEnv, (Element)child);
                continue;
            }
            if ("Body".equals(elName)) {
                this.buildSOAPBody(soapEnv, (Element)child);
                continue;
            }
            log.warn((Object)("Ignore envelope child: " + elName));
        }
        return soapEnv;
    }

    private SOAPHeader buildSOAPHeader(SOAPEnvelopeImpl soapEnv, Element domHeader) throws SOAPException {
        SOAPHeader soapHeader = soapEnv.getHeader();
        if (soapHeader == null) {
            soapHeader = soapEnv.addHeader();
        }
        DOMUtils.copyAttributes((Element)soapHeader, (Element)domHeader);
        if (!soapHeader.getPrefix().equals(domHeader.getPrefix())) {
            soapHeader.setPrefix(domHeader.getPrefix());
        }
        NodeList headerChildNodes = domHeader.getChildNodes();
        for (int i = 0; i < headerChildNodes.getLength(); ++i) {
            Node child = headerChildNodes.item(i);
            short childType = child.getNodeType();
            if (childType == 1) {
                Element srcElement = (Element)child;
                XMLFragment xmlFragment = new XMLFragment(new DOMSource(srcElement));
                NameImpl name = new NameImpl(srcElement.getLocalName(), srcElement.getPrefix(), srcElement.getNamespaceURI());
                SOAPHeaderElementImpl destElement = new SOAPHeaderElementImpl(name);
                soapHeader.addChildElement((SOAPElement)destElement);
                DOMUtils.copyAttributes((Element)((Object)destElement), (Element)srcElement);
                destElement.setXMLFragment(xmlFragment);
                continue;
            }
            if (childType == 3) {
                log.debug((Object)("Ignore child type: " + childType));
                continue;
            }
            log.warn((Object)("Ignore child type: " + childType));
        }
        return soapHeader;
    }

    private SOAPBody buildSOAPBody(SOAPEnvelopeImpl soapEnv, Element domBody) throws SOAPException {
        String envNS = soapEnv.getNamespaceURI();
        SOAPBodyImpl soapBody = (SOAPBodyImpl)soapEnv.getBody();
        if (soapBody == null) {
            soapBody = (SOAPBodyImpl)soapEnv.addBody();
        }
        DOMUtils.copyAttributes((Element)((Object)soapBody), (Element)domBody);
        if (!soapBody.getPrefix().equals(domBody.getPrefix())) {
            soapBody.setPrefix(domBody.getPrefix());
        }
        SOAPBodyElement soapBodyElement = null;
        boolean attachHRefElements = "http://schemas.xmlsoap.org/soap/encoding/".equals(soapEnv.getAttributeNS(envNS, "encodingStyle"));
        NodeList bodyChildNodes = domBody.getChildNodes();
        for (int i = 0; i < bodyChildNodes.getLength(); ++i) {
            Node child = bodyChildNodes.item(i);
            short childType = child.getNodeType();
            if (childType == 1) {
                if (soapBodyElement == null) {
                    soapBodyElement = this.buildSOAPBodyElement(soapEnv, (Element)child);
                    attachHRefElements = attachHRefElements || "http://schemas.xmlsoap.org/soap/encoding/".equals(soapBody.getAttributeNS(envNS, "encodingStyle"));
                    continue;
                }
                if (!attachHRefElements) continue;
                soapBody.addChildElement(this.soapFactory.createElement((Element)child, true));
                continue;
            }
            if (childType == 8) {
                this.appendCommentNode(soapBody, child);
                continue;
            }
            if (childType == 3) {
                this.appendTextNode(soapBody, child);
                continue;
            }
            log.warn((Object)("Ignore child type: " + childType));
        }
        if (attachHRefElements) {
            HRefInlineHandler inlineHandler = new HRefInlineHandler(soapBody);
            inlineHandler.processHRefs();
        }
        return soapBody;
    }

    private SOAPBodyElement buildSOAPBodyElement(SOAPEnvelopeImpl soapEnv, Element domBodyElement) throws SOAPException {
        String envNS = soapEnv.getNamespaceURI();
        String envPrefix = soapEnv.getPrefix();
        SOAPBodyImpl soapBody = (SOAPBodyImpl)soapEnv.getBody();
        QName beName = DOMUtils.getElementQName((Element)domBodyElement);
        SOAPFaultImpl soapBodyElement = null;
        if (beName.equals(new QName(envNS, "Fault"))) {
            SOAPFaultImpl soapFault = new SOAPFaultImpl(envPrefix, envNS);
            soapBody.addChildElement(soapFault);
            soapBodyElement = soapFault;
            DOMUtils.copyAttributes((Element)((Object)soapFault), (Element)domBodyElement);
            XMLFragment xmlFragment = new XMLFragment(new DOMSource(domBodyElement));
            soapFault.setXMLFragment(xmlFragment);
        } else if (this.style == Style.DOCUMENT) {
            this.buildBodyElementDoc(soapBody, domBodyElement);
        } else if (this.style == Style.RPC) {
            soapBodyElement = this.buildBodyElementRpc(soapBody, domBodyElement);
        } else if (this.style == null) {
            this.buildBodyElementDefault(soapBody, domBodyElement);
        } else {
            throw new WSException("Unsupported message style: " + this.style);
        }
        return soapBodyElement;
    }

    @Override
    public SOAPBodyElement buildBodyElementDoc(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException {
        Element srcElement = domBodyElement;
        QName beName = DOMUtils.getElementQName((Element)domBodyElement);
        SOAPBodyElementDoc soapBodyElement = new SOAPBodyElementDoc(beName);
        SOAPContentElement contentElement = (SOAPContentElement)soapBody.addChildElement(soapBodyElement);
        DOMUtils.copyAttributes((Element)((Object)contentElement), (Element)srcElement);
        XMLFragment xmlFragment = new XMLFragment(new DOMSource(srcElement));
        contentElement.setXMLFragment(xmlFragment);
        return soapBodyElement;
    }

    @Override
    public SOAPBodyElement buildBodyElementRpc(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException {
        QName beName = DOMUtils.getElementQName((Element)domBodyElement);
        SOAPBodyElementRpc soapBodyElement = new SOAPBodyElementRpc(beName);
        soapBodyElement = (SOAPBodyElementRpc)soapBody.addChildElement(soapBodyElement);
        DOMUtils.copyAttributes((Element)((Object)soapBodyElement), (Element)domBodyElement);
        NodeList nlist = domBodyElement.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            short childType = child.getNodeType();
            if (childType == 1) {
                Element srcElement = (Element)child;
                NameImpl name = new NameImpl(srcElement.getLocalName(), srcElement.getPrefix(), srcElement.getNamespaceURI());
                SOAPContentElement destElement = new SOAPContentElement(name);
                destElement = (SOAPContentElement)soapBodyElement.addChildElement(destElement);
                DOMUtils.copyAttributes((Element)((Object)destElement), (Element)srcElement);
                XMLFragment xmlFragment = new XMLFragment(new DOMSource(srcElement));
                destElement.setXMLFragment(xmlFragment);
                continue;
            }
            if (childType == 8) {
                this.appendCommentNode(soapBodyElement, child);
                continue;
            }
            if (childType == 3) {
                this.appendTextNode(soapBodyElement, child);
                continue;
            }
            log.warn((Object)("Ignore child type: " + childType));
        }
        return soapBodyElement;
    }

    public SOAPBodyElement buildBodyElementDefault(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException {
        QName beName = DOMUtils.getElementQName((Element)domBodyElement);
        SOAPBodyElementMessage soapBodyElement = new SOAPBodyElementMessage(beName);
        soapBodyElement = (SOAPBodyElementMessage)soapBody.addChildElement(soapBodyElement);
        DOMUtils.copyAttributes((Element)((Object)soapBodyElement), (Element)domBodyElement);
        NodeList nlist = domBodyElement.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            short childType = child.getNodeType();
            if (childType == 1) {
                SOAPElement soapElement = this.soapFactory.createElement((Element)child);
                soapBodyElement.addChildElement(soapElement);
                continue;
            }
            if (childType == 8) {
                this.appendCommentNode(soapBodyElement, child);
                continue;
            }
            if (childType == 3) {
                this.appendTextNode(soapBodyElement, child);
                continue;
            }
            if (childType == 4) {
                String nodeValue = child.getNodeValue();
                soapBodyElement.addTextNode(nodeValue);
                continue;
            }
            log.warn((Object)("Ignore child type: " + childType));
        }
        return soapBodyElement;
    }

    private void appendCommentNode(SOAPElement soapElement, Node child) {
        String nodeValue = child.getNodeValue();
        Document ownerDoc = soapElement.getOwnerDocument();
        Comment comment = ownerDoc.createComment(nodeValue);
        soapElement.appendChild((Node)comment);
    }

    private void appendTextNode(SOAPElement soapElement, Node child) throws SOAPException {
        String nodeValue = child.getNodeValue();
        soapElement.addTextNode(nodeValue);
    }
}

