/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut.ast;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aop.pointcut.ast.ClassExpression;

public class IdentifierExpression {
    private String original;
    private Pattern namePattern;
    private boolean isAnnotation;
    private boolean isImplements;
    private boolean isImplementing;
    private ClassExpression implementsExpr;

    public IdentifierExpression(String expr) {
        this.original = expr;
        if (expr.startsWith("@")) {
            this.isAnnotation = true;
        } else if (expr.startsWith("$implements{")) {
            this.isImplements = true;
            expr = expr.substring(12, expr.length() - 1);
            this.implementsExpr = new ClassExpression(expr.trim());
        } else if (expr.startsWith("$implementing{")) {
            this.isImplementing = true;
            expr = expr.substring(14, expr.length() - 1);
            this.implementsExpr = new ClassExpression(expr.trim());
        } else {
            expr = expr.replaceAll("\\*", ".*");
            this.namePattern = Pattern.compile(expr);
        }
    }

    public boolean matches(String name) {
        if (this.isAnnotation) {
            return false;
        }
        Matcher m = this.namePattern.matcher(name);
        return m.matches();
    }

    public boolean matchesAnnotation(String annotation) {
        if (!this.isAnnotation) {
            return false;
        }
        Matcher m = this.namePattern.matcher(annotation);
        return m.matches();
    }

    public String getOriginal() {
        return this.original;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isImplements() {
        return this.isImplements;
    }

    public boolean isImplementing() {
        return this.isImplementing;
    }

    public ClassExpression getImplementsExpression() {
        return this.implementsExpr;
    }
}

