/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static Method[] getDeclaredMethods(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetDeclaredMethodsAction.NON_PRIVILEGED.getDeclaredMethods(clazz);
        }
        return GetDeclaredMethodsAction.PRIVILEGED.getDeclaredMethods(clazz);
    }

    static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetDeclaredConstructorsAction.NON_PRIVILEGED.getDeclaredConstructors(clazz);
        }
        return GetDeclaredConstructorsAction.PRIVILEGED.getDeclaredConstructors(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetDeclaredConstructorsAction {
        public static final GetDeclaredConstructorsAction PRIVILEGED = new GetDeclaredConstructorsAction(){

            @Override
            public Constructor<?>[] getDeclaredConstructors(final Class<?> clazz) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>[]>(){

                        @Override
                        public Constructor<?>[] run() throws Exception {
                            return clazz.getDeclaredConstructors();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        public static final GetDeclaredConstructorsAction NON_PRIVILEGED = new GetDeclaredConstructorsAction(){

            @Override
            public Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
                return clazz.getDeclaredConstructors();
            }
        };

        public Constructor<?>[] getDeclaredConstructors(Class<?> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetDeclaredMethodsAction {
        public static final GetDeclaredMethodsAction PRIVILEGED = new GetDeclaredMethodsAction(){

            @Override
            public Method[] getDeclaredMethods(final Class<?> clazz) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Method[]>(){

                        @Override
                        public Method[] run() throws Exception {
                            return clazz.getDeclaredMethods();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        public static final GetDeclaredMethodsAction NON_PRIVILEGED = new GetDeclaredMethodsAction(){

            @Override
            public Method[] getDeclaredMethods(Class<?> clazz) {
                return clazz.getDeclaredMethods();
            }
        };

        public Method[] getDeclaredMethods(Class<?> var1);
    }
}

