/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.LevelMapping;

public final class BridgeLogger
extends org.apache.log4j.Logger {
    private static final String FQCN = BridgeLogger.class.getName();
    private final Logger logger;

    public BridgeLogger(Logger logger) {
        super(logger.getName());
        this.logger = logger;
    }

    public void addAppender(Appender newAppender) {
    }

    public void callAppenders(LoggingEvent event) {
    }

    public void fatal(Object message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.FATAL, String.valueOf(message), null);
    }

    public void fatal(Object message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.FATAL, String.valueOf(message), t);
    }

    public void error(Object message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.ERROR, String.valueOf(message), null);
    }

    public void error(Object message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.ERROR, String.valueOf(message), t);
    }

    public void warn(Object message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.WARN, String.valueOf(message), null);
    }

    public void warn(Object message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.WARN, String.valueOf(message), t);
    }

    public void info(Object message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.INFO, String.valueOf(message), null);
    }

    public void info(Object message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.INFO, String.valueOf(message), t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.INFO);
    }

    public void debug(Object message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.DEBUG, String.valueOf(message), null);
    }

    public void debug(Object message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.DEBUG, String.valueOf(message), t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.DEBUG);
    }

    public void trace(Object message) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.TRACE, String.valueOf(message), null);
    }

    public void trace(Object message, Throwable t) {
        this.logger.log(FQCN, (java.util.logging.Level)Level.TRACE, String.valueOf(message), t);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.TRACE);
    }

    protected void forcedLog(String fqcn, Priority level, Object message, Throwable t) {
    }

    public boolean getAdditivity() {
        return this.logger.getUseParentHandlers();
    }

    public Enumeration getAllAppenders() {
        return Collections.enumeration(Collections.emptySet());
    }

    public Appender getAppender(String name) {
        return null;
    }

    public org.apache.log4j.Level getEffectiveLevel() {
        return LevelMapping.getPriorityFor(this.logger.getLevel());
    }

    public Priority getChainedPriority() {
        return this.getEffectiveLevel();
    }

    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    public boolean isAttached(Appender appender) {
        return false;
    }

    public boolean isEnabledFor(Priority level) {
        return this.logger.isLoggable(LevelMapping.getLevelFor(level));
    }

    public void l7dlog(Priority priority, String key, Throwable t) {
        this.logger.log(FQCN, LevelMapping.getLevelFor(priority), key, t);
    }

    public void l7dlog(Priority priority, String key, Object[] params, Throwable t) {
        this.logger.log(FQCN, LevelMapping.getLevelFor(priority), key, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, t);
    }

    public void log(Priority priority, Object message, Throwable t) {
        this.logger.log(FQCN, LevelMapping.getLevelFor(priority), String.valueOf(message), t);
    }

    public void log(Priority priority, Object message) {
        this.logger.log(FQCN, LevelMapping.getLevelFor(priority), String.valueOf(message), null);
    }

    public void log(String callerFQCN, Priority level, Object message, Throwable t) {
        this.logger.log(callerFQCN, LevelMapping.getLevelFor(level), String.valueOf(message), t);
    }

    public void removeAllAppenders() {
    }

    public void removeAppender(Appender appender) {
    }

    public void removeAppender(String name) {
    }

    public void setAdditivity(boolean additive) {
    }

    public void setLevel(org.apache.log4j.Level level) {
        this.setPriority((Priority)level);
    }

    @Deprecated
    public void setPriority(Priority priority) {
        this.logger.setLevel(LevelMapping.getLevelFor(priority));
    }

    public void setResourceBundle(ResourceBundle bundle) {
    }
}

