/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;

public class JBossProvider
extends Provider {
    private static final long serialVersionUID = -6211291745955454828L;
    private static String INFO = "JBoss (X509 key/trust manager factories)";
    private static String NAME = "JBoss";

    public JBossProvider() {
        super(NAME, 1.0, INFO);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JBossProvider.this.put("KeyManagerFactory.SunX509", "org.jboss.security.ssl.KeyManagerFactoryImpl$SunX509");
                JBossProvider.this.put("KeyManagerFactory.IbmX509", "org.jboss.security.ssl.KeyManagerFactoryImpl$IbmX509");
                Provider[] providers = Security.getProviders("TrustManagerFactory.PKIX");
                for (int i = 0; i < providers.length; ++i) {
                    String name = providers[i].getName();
                    if (name.equals("SunJSSE")) {
                        JBossProvider.this.put("TrustManagerFactory.PKIX", "org.jboss.security.ssl.TrustManagerFactoryImpl$SunPKIX");
                        break;
                    }
                    if (!name.equals("IBMJSSE2")) continue;
                    JBossProvider.this.put("TrustManagerFactory.PKIX", "org.jboss.security.ssl.TrustManagerFactoryImpl$IbmPKIX");
                    break;
                }
                return null;
            }
        });
    }
}

