/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.profileservice.bootstrap.AbstractProfileServiceInitializer;
import org.jboss.profileservice.bootstrap.ProfileActivationCallback;
import org.jboss.profileservice.config.ProfileServiceConfig;
import org.jboss.profileservice.domain.AbstractDomainMetaData;
import org.jboss.profileservice.domain.spi.DomainMetaData;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragmentVisitor;
import org.jboss.profileservice.profile.metadata.domain.BasicDomainMetaDataVisitor;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.resolver.BasicResolverFactory;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.dependency.ProfileRequirementResolver;
import org.jboss.profileservice.spi.dependency.ProfileRequirementResolverFactory;

public abstract class AbstractProfileServiceBootstrap
extends AbstractProfileServiceInitializer
implements ProfileActivationCallback,
ProfileRequirementResolverFactory {
    protected static final Logger log = Logger.getLogger((String)"ProfileServiceBootstrap");
    private final Kernel kernel;
    private List<ProfileKey> activatedProfiles = new ArrayList<ProfileKey>();
    private ProfileRequirementResolverFactory resolverFactory;
    private volatile boolean isShutdown = false;

    public AbstractProfileServiceBootstrap(Kernel kernel, ProfileServiceConfig config) {
        super(config);
        this.kernel = kernel;
    }

    @Override
    protected Kernel getKernel() {
        return this.kernel;
    }

    protected ProfileService createProfileService(AbstractDomainMetaData domainMetaData) throws Throwable {
        super.initialize(domainMetaData);
        this.resolverFactory = new BasicResolverFactory(this.getProfileRepository(), this);
        return this.getProfileService();
    }

    protected void start(AbstractDomainMetaData domainMetaData) throws Throwable {
        ProfileRequirementResolver resolver = this.createResolver((DomainMetaData)domainMetaData);
        BasicDomainMetaDataVisitor visitor = new BasicDomainMetaDataVisitor(resolver, this.getProfileRepository());
        domainMetaData.visit((DomainMetaDataFragmentVisitor)visitor);
        resolver.resolve();
        resolver.deploy();
    }

    @Override
    public void activate(ProfileMetaDataContext context) throws Exception {
        this.checkShutdown();
        ProfileKey key = context.getKey();
        if (!this.activatedProfiles.contains(key)) {
            try {
                this.getActivationService().installProfile(context, null);
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            this.getActivationService().activate(key);
            this.activatedProfiles.add(0, key);
        }
        this.getProfileService().validateProfile(key);
    }

    protected void prepareShutdown() {
        this.isShutdown = true;
    }

    protected void stop(DomainMetaData domainMetaData) {
        for (ProfileKey key : this.activatedProfiles) {
            try {
                this.getActivationService().deactivate(key);
            }
            catch (NoSuchProfileException ignore) {
                log.warn((Object)("failed to deactivate profile " + key));
            }
        }
        for (ProfileKey key : this.activatedProfiles) {
            try {
                this.getProfileService().unregisterProfile(key);
            }
            catch (NoSuchProfileException ignore) {
                log.warn((Object)("failed to unregister profile " + key));
            }
        }
    }

    protected ProfileRequirementResolver createResolver(DomainMetaData domainMetaData) {
        return this.createResolver(this.getConfig().getServerConfiguration().getServerName());
    }

    public ProfileRequirementResolver createResolver(String name) {
        return this.resolverFactory.createResolver(name);
    }

    protected void checkShutdown() {
        if (this.isShutdown) {
            throw new IllegalStateException("deployers are shutdown!");
        }
    }
}

