/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.deployment;

import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentInfo;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;

public class AbstractDeploymentInfo
implements ProfileDeploymentInfo {
    private final String name;
    private final VirtualDeploymentMetaData deploymentMetaData;
    private volatile int dFlags = 0;

    public AbstractDeploymentInfo(String name, VirtualDeploymentMetaData deploymentMetaData) {
        if (name == null) {
            throw new IllegalArgumentException("null deployment name");
        }
        if (deploymentMetaData == null) {
            throw new IllegalArgumentException("null deployment meta data");
        }
        this.name = name;
        this.deploymentMetaData = deploymentMetaData;
    }

    public String getName() {
        return this.name;
    }

    public VirtualDeploymentMetaData getMetaData() {
        return this.deploymentMetaData;
    }

    public boolean hasFlag(ProfileDeploymentFlag flag) {
        return (this.dFlags & flag.getFlag()) == flag.getFlag();
    }

    public boolean isDeployed() {
        return this.hasFlag(ProfileDeploymentFlag.DEPLOYED);
    }

    public boolean isLocked() {
        return this.hasFlag(ProfileDeploymentFlag.LOCKED);
    }

    public void setFlag(ProfileDeploymentFlag flag) {
        this.dFlags |= flag.getFlag();
    }

    public void clearFlag(ProfileDeploymentFlag flag) {
        this.dFlags &= ~flag.getFlag();
    }
}

