/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.repository.ProfileMetaDataRepository;
import org.jboss.profileservice.repository.ProfileRepositories;
import org.jboss.profileservice.resolver.ProfileRequirementResolutionContext;
import org.jboss.profileservice.resolver.ProfileResolutionFilter;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.dependency.ProfileCapability;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class AbstractProfileRepository
implements ProfileMetaDataRepository {
    private final ProfileRepositories repositories;
    private Map<String, ProfileMetaDataContext> registered = new ConcurrentHashMap<String, ProfileMetaDataContext>();

    public AbstractProfileRepository(ProfileRepositories repositories) {
        this.repositories = repositories;
    }

    @Override
    public boolean isRegistered(String profileName) {
        return this.registered.containsKey(profileName);
    }

    @Override
    public ProfileMetaDataContext registerMetaData(ProfileMetaData metaData) {
        String profileName = metaData.getName();
        if (this.registered.containsKey(profileName)) {
            throw new IllegalStateException("duplicate profile " + profileName);
        }
        ProfileMetaDataContext context = this.repositories.createMetaDataContext(profileName, metaData);
        this.registered.put(profileName, context);
        return context;
    }

    @Override
    public void unRegisterMetaData(String profileName) {
        this.registered.remove(profileName);
    }

    @Override
    public ProfileMetaDataContext resolve(String profileName) {
        if (profileName == null) {
            throw new IllegalArgumentException("null profile name");
        }
        return this.registered.get(profileName);
    }

    @Override
    public boolean accepts(ProfileMetaDataContext context) {
        String profileName = context.getProfileName();
        return !this.isRegistered(profileName);
    }

    @Override
    public ProfileKey resolve(ProfileRequirementResolutionContext resolutionContext, ProfileResolutionFilter filter) {
        ProfileKey resolved = null;
        ProfileRequirement requirement = resolutionContext.getRequirement();
        block0: for (ProfileMetaDataContext other : this.registered.values()) {
            Collection<ProfileCapability> capabilities;
            if (filter != null && !filter.accepts(other) || (capabilities = other.getCapabilities()) == null || capabilities.isEmpty()) continue;
            for (ProfileCapability capability : capabilities) {
                if (!capability.resolves(requirement)) continue;
                ProfileKey r = other.getKey();
                resolutionContext.addResolved(r);
                if (resolved == null) {
                    resolved = r;
                    continue block0;
                }
                return null;
            }
        }
        return resolved;
    }
}

