/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact.maven;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.profileservice.repository.artifact.AbstractRepositoryId;
import org.jboss.profileservice.repository.artifact.maven.AbstractMavenArtifactRepository;
import org.jboss.profileservice.repository.artifact.maven.MavenArtifact;
import org.jboss.profileservice.repository.artifact.maven.MavenArtifactId;
import org.jboss.profileservice.repository.artifact.maven.MavenArtifactMetaData;
import org.jboss.profileservice.repository.artifact.maven.MavenArtifactRepositoryMetaData;
import org.jboss.profileservice.spi.repository.artifact.Artifact;
import org.jboss.profileservice.spi.repository.artifact.ArtifactFilter;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryConfiguration;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryFactory;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.vfs.VirtualFile;

public class LocalMavenArtifactRepository
extends AbstractMavenArtifactRepository
implements ArtifactRepositoryFactory<MavenArtifactId> {
    private final MavenArtifactRepositoryMetaData metaData;
    private final List<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
    public static final ArtifactRepositoryId REPOSITORY_ID = new AbstractRepositoryId("###DEFAULT###", MavenArtifactId.TYPE);

    public LocalMavenArtifactRepository(MavenArtifactRepositoryMetaData metaData, URI root) throws IOException {
        super(REPOSITORY_ID, root);
        if (metaData == null) {
            throw new IllegalArgumentException("null artifact repository meta data");
        }
        this.metaData = metaData;
        this.initialize();
    }

    public boolean containsArtifact(MavenArtifactId artifactId) {
        return this.resolveArtifact(artifactId) != null;
    }

    public Artifact<MavenArtifactId> getArtifact(MavenArtifactId artifactId) {
        return this.resolveArtifact(artifactId);
    }

    public Collection<Artifact<MavenArtifactId>> getArtifacts() {
        ArrayList<Artifact<MavenArtifactId>> artifacts = new ArrayList<Artifact<MavenArtifactId>>();
        for (MavenArtifact artifact : this.artifacts) {
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public Collection<Artifact<MavenArtifactId>> getArtifacts(ArtifactFilter<MavenArtifactId> filter) {
        ArrayList<Artifact<MavenArtifactId>> filtered = new ArrayList<Artifact<MavenArtifactId>>();
        for (Artifact<MavenArtifactId> artifact : this.getArtifacts()) {
            if (!filter.accepts(artifact)) continue;
            filtered.add(artifact);
        }
        return filtered;
    }

    public VirtualFile getArtifactFile(MavenArtifactId artifactId) throws IOException {
        MavenArtifact artifact = this.resolveArtifact(artifactId);
        if (artifact == null) {
            this.getConfiguration().getNotFoundHandler().handleArtifactNotFound((ArtifactRepository)this, (ArtifactId)artifactId);
        }
        return this.resolveArtifactFile(artifact.getIdentifier());
    }

    public VirtualFile getOriginalFile(MavenArtifactId artifact) throws IOException {
        return this.getArtifactFile(artifact);
    }

    protected MavenArtifact resolveArtifact(MavenArtifactId artifactId) {
        for (MavenArtifact artifact : this.artifacts) {
            if (!artifactId.matches(artifact.getIdentifier())) continue;
            return artifact;
        }
        return null;
    }

    public ArtifactRepository<MavenArtifactId> createArtifactRepository(ArtifactRepositoryId repositoryId, ArtifactRepositoryConfiguration<MavenArtifactId> configuration) throws IOException {
        return this;
    }

    public String getRepositoryType() {
        return MavenArtifactId.TYPE;
    }

    protected void checkConsistent() {
    }

    protected void initialize() {
        if (this.metaData.getArtifacts() != null && !this.metaData.getArtifacts().isEmpty()) {
            for (MavenArtifactMetaData artifactId : this.metaData.getArtifacts()) {
                this.artifacts.add(new MavenArtifact(artifactId, this));
            }
        }
    }
}

