/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.resolver;

import org.jboss.profileservice.resolver.ProfileRequirementResolutionContext;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;

class ProfileNodeDependency {
    private final ProfileKey to;
    private boolean optional;
    private boolean optionalDependsOnTo;
    private boolean resolved = false;
    private final boolean requireInstalled;
    private final ProfileRequirementResolutionContext resolution;
    private final ProfileRequirement requirement;

    public ProfileNodeDependency(ProfileRequirementResolutionContext resolution, ProfileKey to, ProfileRequirement requirement, boolean optional, boolean requireInstalled) {
        this.resolution = resolution;
        this.to = to;
        this.optional = optional;
        this.requirement = requirement;
        this.requireInstalled = requireInstalled;
    }

    ProfileKey getFrom() {
        return this.resolution.getMetaDataContext().getKey();
    }

    ProfileKey getTo() {
        return this.to;
    }

    boolean isOptional() {
        return this.optional;
    }

    void hardenDependency() {
        this.optional = false;
    }

    boolean isOptionalDependsOnTo() {
        return this.optionalDependsOnTo;
    }

    void weakenOptionalDependsOnTo() {
        this.optionalDependsOnTo = true;
    }

    void hardenOptionalDependsOnTo() {
        this.optionalDependsOnTo = false;
    }

    boolean isResolved() {
        return this.resolved;
    }

    void markAsResolved() {
        this.resolved = true;
    }

    ProfileRequirement getRequirement() {
        return this.requirement;
    }

    boolean isRequireInstalled() {
        return this.requireInstalled;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("dependency{");
        builder.append(this.getFrom()).append(" >> ").append(this.getTo());
        builder.append(", optional=").append(this.isOptional());
        if (this.isOptionalDependsOnTo()) {
            builder.append(", optionalDependsOnTo=true");
        }
        builder.append("}");
        return builder.toString();
    }
}

