/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.virtual.assembly;

import java.io.Closeable;
import java.io.IOException;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.virtual.VirtualArtifactMetaData;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;
import org.jboss.profileservice.spi.virtual.assembly.VirtualDeploymentAssembly;
import org.jboss.profileservice.spi.virtual.assembly.VirtualDeploymentAssemblyContext;
import org.jboss.profileservice.virtual.assembly.BasicVirtualAssemblyContext;
import org.jboss.profileservice.virtual.assembly.ImmutableAssemblyContext;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileAssembly;

public abstract class AbstractVirtualDeploymentAssembly
implements VirtualDeploymentAssembly {
    protected abstract VirtualFile getOriginalVirtualFile(ArtifactId var1) throws IOException;

    protected abstract VirtualFile getAssembledRoot();

    public VirtualDeploymentAssemblyContext assemble(VirtualDeploymentMetaData deployment) throws IOException {
        if (deployment == null) {
            throw new IllegalArgumentException("null virtual deployment");
        }
        if (deployment.getName() == null) {
            throw new IllegalArgumentException("null virtual deployment name");
        }
        VirtualDeploymentAssemblyContext ctx = this.createAssemblyContext(deployment);
        this.assemble(ctx, deployment);
        return ctx;
    }

    protected void assemble(VirtualDeploymentAssemblyContext ctx, VirtualDeploymentMetaData deployment) throws IOException {
        if (deployment.getArtifacts() != null && !deployment.getArtifacts().isEmpty()) {
            for (VirtualArtifactMetaData artifact : deployment.getArtifacts()) {
                ctx.addArtifact(artifact);
            }
        }
        if (deployment.getChildren() != null && !deployment.getChildren().isEmpty()) {
            for (VirtualDeploymentMetaData child : deployment.getChildren()) {
                VirtualDeploymentAssemblyContext childCtx = ctx.addChild(child);
                this.assemble(childCtx, child);
            }
        }
    }

    protected String createDeploymentName(VirtualDeploymentMetaData deployment) {
        return deployment.getName();
    }

    protected VirtualDeploymentAssemblyContext createAssemblyContext(VirtualDeploymentMetaData deployment) throws IOException {
        VirtualDeploymentAssemblyContext ctx = this.createNonAssembledContext(deployment);
        if (ctx == null) {
            return this.assembleNewContext(deployment);
        }
        return ctx;
    }

    protected VirtualDeploymentAssemblyContext createChildAssemblyContext(VirtualDeploymentMetaData deployment, VirtualFile parent) throws IOException {
        VirtualDeploymentAssemblyContext ctx = this.createNonAssembledContext(deployment);
        if (ctx == null) {
            VirtualFileAssembly child = new VirtualFileAssembly();
            VirtualFile mountPoint = parent.getChild(deployment.getName());
            Closeable closeable = VFS.mountAssembly((VirtualFileAssembly)child, (VirtualFile)mountPoint);
            return this.createAssemblyContext(child, mountPoint, closeable);
        }
        return ctx;
    }

    protected VirtualDeploymentAssemblyContext assembleNewContext(VirtualDeploymentMetaData deployment) throws IOException {
        String fileName = this.createDeploymentName(deployment);
        VirtualFileAssembly assembly = new VirtualFileAssembly();
        VirtualFile mountPoint = this.getAssembledRoot().getChild(fileName);
        Closeable closeable = VFS.mountAssembly((VirtualFileAssembly)assembly, (VirtualFile)mountPoint);
        return this.createAssemblyContext(assembly, mountPoint, closeable);
    }

    protected VirtualDeploymentAssemblyContext createAssemblyContext(VirtualFileAssembly assembly, VirtualFile vf, Closeable closeable) {
        return new BasicVirtualAssemblyContext(assembly, vf, closeable, this);
    }

    protected VirtualDeploymentAssemblyContext createNonAssembledContext(VirtualDeploymentMetaData deployment) throws IOException {
        if (deployment.getArtifact() != null) {
            VirtualFile vf = this.getOriginalVirtualFile(deployment.getArtifact());
            return new ImmutableAssemblyContext(vf);
        }
        return null;
    }
}

