/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.commons.logging.LogFactory;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.TomcatInjectionContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebCtxLoader
implements Lifecycle,
Loader {
    private static final Logger log = Logger.getLogger(WebCtxLoader.class);
    protected ClassLoader encLoader;
    protected ENCLoader ctxLoader;
    protected Container webContainer;
    protected URL warURL;
    protected TomcatInjectionContainer injectionContainer;
    private ArrayList repositories = new ArrayList();

    public WebCtxLoader(ClassLoader encLoader) {
        this(encLoader, null);
    }

    public WebCtxLoader(ClassLoader encLoader, TomcatInjectionContainer container) {
        this.encLoader = encLoader;
        this.ctxLoader = new ENCLoader(encLoader);
        this.injectionContainer = container;
    }

    public void setClasspath(List<URL> classpath) {
        for (URL path : classpath) {
            this.ctxLoader.addURLInternal(path);
        }
    }

    public void setWarURL(URL warURL) throws MalformedURLException {
        File libDir;
        this.warURL = warURL;
        String path = warURL.getFile();
        File classesDir = new File(path, "WEB-INF/classes");
        if (classesDir.exists()) {
            this.ctxLoader.addURLInternal(classesDir.toURL());
        }
        if ((libDir = new File(path, "WEB-INF/lib")).exists()) {
            File[] jars = libDir.listFiles();
            int length = jars != null ? jars.length : 0;
            for (int j = 0; j < length; ++j) {
                File jar = jars[j];
                if (!jar.getAbsolutePath().endsWith(".jar")) continue;
                this.ctxLoader.addURLInternal(jar.toURL());
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public void start() throws LifecycleException {
        ServletContext servletContext;
        if (this.ctxLoader == null) {
            throw new LifecycleException("WebCtxLoader cannot be restarted");
        }
        if (this.injectionContainer != null) {
            log.debug((Object)"injectionContainer enabled and processing beginning with JBoss WebCtxLoader");
            this.injectionContainer.setClassLoader(this.getClassLoader());
            this.injectionContainer.processMetadata();
        }
        if ((servletContext = ((Context)this.webContainer).getServletContext()) == null) {
            return;
        }
    }

    public void stop() throws LifecycleException {
        DirContextURLStreamHandler.unbind((ClassLoader)this.ctxLoader);
        LogFactory.release((ClassLoader)this.ctxLoader);
        LogFactory.release((ClassLoader)this.encLoader);
        this.encLoader = null;
        this.ctxLoader = null;
        this.repositories.clear();
        this.warURL = null;
        this.webContainer = null;
    }

    public void backgroundProcess() {
    }

    public ClassLoader getClassLoader() {
        return this.ctxLoader;
    }

    public Container getContainer() {
        return this.webContainer;
    }

    public void setContainer(Container container) {
        this.webContainer = container;
    }

    public boolean getDelegate() {
        return false;
    }

    public void setDelegate(boolean delegate) {
    }

    public String getInfo() {
        return null;
    }

    public boolean getReloadable() {
        return false;
    }

    public void setReloadable(boolean reloadable) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void addRepository(String repository) {
        if (this.repositories.contains(repository)) {
            return;
        }
        this.repositories.add(repository);
    }

    public String[] findLoaderRepositories() {
        return this.findRepositories();
    }

    public String[] findRepositories() {
        String[] tmp = new String[this.repositories.size()];
        this.repositories.toArray(tmp);
        return tmp;
    }

    public boolean modified() {
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    static class ENCLoader
    extends URLClassLoader {
        private URL[] urllist = new URL[0];

        ENCLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        void addURLInternal(URL url) {
            URL[] result = new URL[this.urllist.length + 1];
            for (int i = 0; i < this.urllist.length; ++i) {
                result[i] = this.urllist[i];
            }
            result[this.urllist.length] = url;
            this.urllist = result;
        }

        public URL[] getURLs() {
            return this.urllist;
        }
    }
}

