/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.serialization.impl.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.crypto.SealedObject;
import org.jboss.remoting.marshal.encryption.EncryptionUtil;
import org.jboss.remoting.serialization.impl.java.JavaSerializationManager;

public class JavaEncryptionSerializationManager
extends JavaSerializationManager {
    @Override
    public Object receiveObject(InputStream inputStream, ClassLoader customClassLoader, int version) throws IOException, ClassNotFoundException {
        Object obj = super.receiveObject(inputStream, customClassLoader, version);
        if (obj instanceof SealedObject) {
            try {
                obj = EncryptionUtil.unsealObject((SealedObject)obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    @Override
    public void sendObject(ObjectOutputStream oos, Object dataObject, int version) throws IOException {
        if (dataObject instanceof Serializable) {
            try {
                dataObject = EncryptionUtil.sealObject((Serializable)dataObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.sendObject(oos, dataObject, version);
    }
}

