/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Random;
import org.jboss.logging.Logger;

public class PortUtil {
    public static final String MIN_PORT = "minPort";
    public static final String MAX_PORT = "maxPort";
    private static final Logger log = Logger.getLogger(PortUtil.class);
    private static final int MIN_UNPRIVILEGED_PORT = 1024;
    private static final int MAX_LEGAL_PORT = 65535;
    private static int portCounter = 0;
    private static int retryMax = 50;
    private static int minPort = 1024;
    private static int maxPort = 65535;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPort(final int p, final String host) {
        boolean available = true;
        ServerSocket socket = null;
        try {
            try {
                socket = (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        InetAddress inetAddress = InetAddress.getByName(host);
                        return new ServerSocket(p, 0, inetAddress);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                available = false;
                throw (IOException)e.getCause();
            }
        }
        catch (UnknownHostException e) {
            log.warn((Object)("unknown host: " + host));
        }
        catch (IOException e) {
            if ("Protocol family unavailable".equalsIgnoreCase(e.getMessage()) || "Protocol family not supported".equalsIgnoreCase(e.getMessage())) {
                log.debug((Object)("perhaps IPv6 is not available: " + e.getMessage()));
            } else {
                log.debug((Object)("port " + p + " already in use.  Will try another."), e.getCause());
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
        return available;
    }

    public static int findFreePort(String host) throws IOException {
        int tryCount;
        Integer port = null;
        for (tryCount = 0; port == null && tryCount < retryMax; ++tryCount) {
            port = PortUtil.getFreePort(host);
            if (port == null || PortUtil.checkPort(port, host)) continue;
            port = null;
        }
        if (tryCount >= retryMax) {
            throw new IOException("Can not find a free port for use.");
        }
        return port;
    }

    private static Integer getFreePort(String host) {
        int p = PortUtil.getNextPort();
        if (PortUtil.checkPort(p, host)) {
            return new Integer(p);
        }
        return null;
    }

    private static synchronized int getNextPort() {
        if (portCounter < maxPort) {
            return portCounter++;
        }
        portCounter = minPort;
        return maxPort;
    }

    public static int getRandomStartingPort() {
        int range = maxPort - minPort + 1;
        int port = new Random(System.currentTimeMillis()).nextInt(range) + minPort;
        return port;
    }

    public static synchronized int getMinPort() {
        return minPort;
    }

    public static synchronized void setMinPort(int minPort) throws IllegalStateException {
        if (minPort > maxPort) {
            String msg = "trying to set minPort to value greater than maxPort: " + minPort + " > " + maxPort;
            log.debug((Object)msg);
            throw new IllegalStateException(msg);
        }
        if (minPort < PortUtil.minPort) {
            log.debug((Object)("will not set minPort to " + minPort + ": minPort is already " + PortUtil.minPort));
            return;
        }
        log.debug((Object)("setting minPort to " + minPort));
        PortUtil.minPort = minPort;
    }

    public static synchronized int getMaxPort() {
        return maxPort;
    }

    public static synchronized void setMaxPort(int maxPort) {
        if (maxPort < minPort) {
            String msg = "trying to set maxPort to value less than minPort: " + maxPort + " < " + minPort;
            log.debug((Object)msg);
            throw new IllegalStateException(msg);
        }
        if (maxPort > PortUtil.maxPort) {
            log.debug((Object)("will not set maxPort to " + maxPort + ": maxPort is already " + PortUtil.maxPort));
            return;
        }
        log.debug((Object)("setting maxPort to " + maxPort));
        PortUtil.maxPort = maxPort;
    }

    public static synchronized void updateRange(Map config) {
        if (config != null) {
            int savedMinPort = PortUtil.getMinPort();
            Object o = config.get(MIN_PORT);
            if (o instanceof String) {
                try {
                    PortUtil.setMinPort(Integer.parseInt((String)o));
                }
                catch (NumberFormatException e) {
                    log.error((Object)("minPort parameter has invalid format: " + o));
                }
            } else if (o != null) {
                log.error((Object)("minPort parameter must be a string in integer format: " + o));
            }
            int savedMaxPort = PortUtil.getMaxPort();
            o = config.get(MAX_PORT);
            if (o instanceof String) {
                try {
                    PortUtil.setMaxPort(Integer.parseInt((String)o));
                }
                catch (NumberFormatException e) {
                    log.error((Object)("maxPort parameter has invalid format: " + o));
                }
            } else if (o != null) {
                log.error((Object)("maxPort parameter must be a string in integer format: " + o));
            }
            if (savedMinPort != PortUtil.getMinPort() || savedMaxPort != PortUtil.getMaxPort()) {
                portCounter = PortUtil.getRandomStartingPort();
            }
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("port - " + PortUtil.findFreePort("localhost"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        portCounter = PortUtil.getRandomStartingPort();
    }
}

