/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.xa.XAResourceWrapperImpl;
import org.jboss.resource.metadata.ConfigPropertyMetaData;
import org.jboss.resource.metadata.ConnectionDefinitionMetaData;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.DescriptionGroupMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryPropertyMetaData;
import org.jboss.resource.metadata.mcf.SecurityMetaData;
import org.jboss.resource.metadata.mcf.XAConnectionPropertyMetaData;
import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectFactory;
import org.jboss.system.ServiceDynamicMBeanSupport;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.jboss.util.Classes;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Element;

public class ManagedConnectionFactoryDeployment
extends ServiceDynamicMBeanSupport
implements ManagedConnectionFactory,
XAResourceRecovery {
    private static final long serialVersionUID = -8448602289610025849L;
    public static final String MCF_ATTRIBUTE_CHANGED_NOTIFICATION = "jboss.mcfattributechangednotification";
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private ObjectName oldRarDeployment;
    private String rarName;
    private String connectionDefinition;
    private String vendorName;
    private String specVersion;
    private String eisType;
    private String version;
    private String managedConnectionFactoryClass;
    private String connectionFactoryInterface;
    private String connectionFactoryImplClass;
    private String connectionInterface;
    private String connectionImplClass;
    private String transactionSupport;
    private Element managedConnectionFactoryProperties;
    private String authenticationMechanismType;
    private String credentialInterface;
    private boolean reauthenticationSupport;
    private Class mcfClass;
    private String jndiName;
    private ManagedConnectionFactory mcf;
    private ManagedConnectionFactoryDeploymentMetaData dmd;
    private ConnectorMetaData cmd;
    private boolean recoveryRegistered = false;
    private XAResourceRecoveryRegistry xrrr = null;
    private SubjectFactory subjectFactory = null;
    private ManagedConnection recoverMC = null;
    private String securityDomain = null;
    private String recoverSecurityDomain = null;
    private String recoverUserName = null;
    private String recoverPassword = null;
    private String connectionManager = null;

    public ManagedConnectionFactoryDeployment() {
    }

    public ManagedConnectionFactoryDeployment(ConnectorMetaData cmd, ManagedConnectionFactoryDeploymentMetaData dmd, String connectionManager) {
        this.cmd = cmd;
        this.dmd = dmd;
        this.connectionManager = connectionManager;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getRARName() {
        return this.rarName;
    }

    public void setRARName(String rarName) {
        this.rarName = rarName;
    }

    public String getConnectionDefinition() {
        return this.connectionDefinition;
    }

    public void setConnectionDefinition(String connectionDefinition) {
        this.connectionDefinition = connectionDefinition;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String eisType) {
        this.eisType = eisType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass) {
        this.managedConnectionFactoryClass = managedConnectionFactoryClass;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        this.connectionFactoryInterface = connectionFactoryInterface;
    }

    public String getConnectionFactoryImplClass() {
        return this.connectionFactoryImplClass;
    }

    public void setConnectionFactoryImplClass(String connectionFactoryImplClass) {
        this.connectionFactoryImplClass = connectionFactoryImplClass;
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public void setConnectionInterface(String connectionInterface) {
        this.connectionInterface = connectionInterface;
    }

    public String getConnectionImplClass() {
        return this.connectionImplClass;
    }

    public void setConnectionImplClass(String connectionImplClass) {
        this.connectionImplClass = connectionImplClass;
    }

    public String getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(String transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public Element getManagedConnectionFactoryProperties() {
        return this.managedConnectionFactoryProperties;
    }

    public void setManagedConnectionFactoryProperties(Element managedConnectionFactoryProperties) {
        this.managedConnectionFactoryProperties = managedConnectionFactoryProperties;
    }

    public String getAuthenticationMechanismType() {
        return this.authenticationMechanismType;
    }

    public void setAuthenticationMechanismType(String authenticationMechanismType) {
        this.authenticationMechanismType = authenticationMechanismType;
    }

    public String getCredentialInterface() {
        return this.credentialInterface;
    }

    public void setCredentialInterface(String credentialInterface) {
        this.credentialInterface = credentialInterface;
    }

    public boolean isReauthenticationSupport() {
        return this.reauthenticationSupport;
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        this.reauthenticationSupport = reauthenticationSupport;
    }

    public ManagedConnectionFactory getMcfInstance() {
        return this.mcf;
    }

    public XAResourceRecoveryRegistry getXAResourceRecoveryRegistry() {
        return this.xrrr;
    }

    public void setXAResourceRecoveryRegistry(XAResourceRecoveryRegistry xrrr) {
        this.xrrr = xrrr;
    }

    public SubjectFactory getSubjectFactory() {
        return this.subjectFactory;
    }

    public void setSubjectFactory(SubjectFactory sf) {
        this.subjectFactory = sf;
    }

    public String getConnectionManager() {
        return this.connectionManager;
    }

    protected void startService() throws Exception {
        if (this.mcf != null) {
            throw new DeploymentException("Stop the RARDeployment before restarting it");
        }
        ResourceAdapter resourceAdapter = null;
        ConnectionDefinitionMetaData cdmd = this.cmd.getConnectionDefinition(this.dmd.getConnectionDefinition());
        this.rarName = this.dmd.getRarName();
        try {
            resourceAdapter = (ResourceAdapter)this.getServer().getAttribute(this.oldRarDeployment, "ResourceAdapter");
            if (cdmd == null) {
                throw new DeploymentException("ConnectionDefinition '" + this.connectionDefinition + "' not found in rar '" + this.rarName + "'");
            }
            this.setManagedConnectionFactoryClass(cdmd.getManagedConnectionFactoryClass());
            this.setReauthenticationSupport(this.cmd.getReauthenticationSupport());
        }
        catch (Exception e) {
            throw new DeploymentException("couldn't get oldRarDeployment! " + this.oldRarDeployment, (Throwable)e);
        }
        try {
            this.mcfClass = Thread.currentThread().getContextClassLoader().loadClass(cdmd.getManagedConnectionFactoryClass());
        }
        catch (ClassNotFoundException cnfe) {
            this.log.error((Object)("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass), (Throwable)cnfe);
            throw new DeploymentException("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass);
        }
        try {
            this.mcf = (ManagedConnectionFactory)this.mcfClass.newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass), (Throwable)e);
            throw new DeploymentException("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass);
        }
        if (this.cmd != null) {
            this.setMcfProperties(this.cmd.getProperties(), false);
            this.setMcfProperties(cdmd.getProperties(), true);
        }
        this.setManagedConnectionFactoryProperties(this.dmd.getManagedConnectionFactoryProperties());
        if (resourceAdapter != null && this.mcf instanceof ResourceAdapterAssociation) {
            ResourceAdapterAssociation raa = (ResourceAdapterAssociation)this.mcf;
            raa.setResourceAdapter(resourceAdapter);
        }
        if (this.dmd instanceof XADataSourceDeploymentMetaData) {
            XADataSourceDeploymentMetaData xdsdm = (XADataSourceDeploymentMetaData)this.dmd;
            if (this.getXAResourceRecoveryRegistry() != null && !xdsdm.isNoRecover().booleanValue()) {
                SecurityMetaData securityDomainMD;
                SecurityMetaData recoverSecurityDomainMD = xdsdm.getRecoverSecurityMetaData();
                if (recoverSecurityDomainMD != null) {
                    this.recoverSecurityDomain = recoverSecurityDomainMD.getDomain();
                }
                if ((securityDomainMD = xdsdm.getSecurityMetaData()) != null) {
                    this.securityDomain = securityDomainMD.getDomain();
                }
                this.recoverUserName = xdsdm.getRecoverUserName();
                this.recoverPassword = xdsdm.getRecoverPassWord();
                if (this.recoverUserName == null) {
                    for (XAConnectionPropertyMetaData xcpmd : xdsdm.getXADataSourceProperties()) {
                        if (!xcpmd.getName().equals("User")) continue;
                        this.recoverUserName = xcpmd.getValue();
                    }
                }
                if (this.recoverPassword == null) {
                    for (XAConnectionPropertyMetaData xcpmd : xdsdm.getXADataSourceProperties()) {
                        if (!xcpmd.getName().equals("Password")) continue;
                        this.recoverPassword = xcpmd.getValue();
                    }
                }
                if (this.recoverUserName == null) {
                    this.recoverUserName = xdsdm.getUserName();
                }
                if (this.recoverPassword == null) {
                    this.recoverPassword = xdsdm.getPassWord();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Registered for XA Resource Recovery: " + xdsdm.getJndiName()));
                }
                if (this.log.isDebugEnabled()) {
                    if (this.recoverUserName != null) {
                        this.log.debug((Object)("RecoverUserName=" + this.recoverUserName));
                    } else if (this.recoverSecurityDomain != null) {
                        this.log.debug((Object)("RecoverSecurityDomain=" + this.recoverSecurityDomain));
                    } else if (this.securityDomain != null) {
                        this.log.debug((Object)("RecoverSecurityDomain=" + this.securityDomain));
                    }
                }
                this.getXAResourceRecoveryRegistry().addXAResourceRecovery((XAResourceRecovery)this);
                this.recoveryRegistered = true;
            }
        }
    }

    protected void stopService() {
        if (this.recoveryRegistered && this.getXAResourceRecoveryRegistry() != null) {
            this.close(this.recoverMC);
            this.getXAResourceRecoveryRegistry().removeXAResourceRecovery((XAResourceRecovery)this);
            this.recoveryRegistered = false;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Unregistered for XA Resource Recovery: " + this.dmd.getJndiName()));
            }
        }
        this.mcf = null;
        this.mcfClass = null;
    }

    public XAResource[] getXAResources() {
        block18: {
            if (this.recoveryRegistered) {
                try {
                    Subject subject = this.getSubject();
                    if (subject != null) {
                        Object xaResource;
                        block17: {
                            ManagedConnection mc = this.open(subject);
                            xaResource = null;
                            try {
                                xaResource = mc.getXAResource();
                            }
                            catch (ResourceException reconnect) {
                                this.close(mc);
                                mc = this.open(subject);
                                xaResource = mc.getXAResource();
                            }
                            try {
                                ObjectName on = new ObjectName(this.connectionManager);
                                boolean wrapXAResource = false;
                                boolean padXid = false;
                                Boolean isSameRMOverrideValue = Boolean.FALSE;
                                Boolean b = null;
                                b = (Boolean)this.getServer().getAttribute(on, "WrapXAResource");
                                if (b != null) {
                                    wrapXAResource = b;
                                }
                                if ((b = (Boolean)this.getServer().getAttribute(on, "PadXid")) != null) {
                                    padXid = b;
                                }
                                if ((b = (Boolean)this.getServer().getAttribute(on, "IsSameRMOverrideValue")) != null) {
                                    isSameRMOverrideValue = b;
                                }
                                if (!wrapXAResource) break block17;
                                String eisProductName = null;
                                String eisProductVersion = null;
                                try {
                                    eisProductName = mc.getMetaData().getEISProductName();
                                    eisProductVersion = mc.getMetaData().getEISProductVersion();
                                }
                                catch (ResourceException re) {
                                    // empty catch block
                                }
                                xaResource = new XAResourceWrapperImpl((XAResource)xaResource, padXid, isSameRMOverrideValue, eisProductName, eisProductVersion);
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Recovery XAResource=" + xaResource + " for " + this.dmd.getJndiName()));
                        }
                        return new XAResource[]{xaResource};
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Subject for recovery was null");
                    }
                    break block18;
                }
                catch (ResourceException re) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Error during recovery", (Throwable)re);
                    }
                    break block18;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Recovery not registered for " + this.dmd.getJndiName()));
            }
        }
        return new XAResource[0];
    }

    private Subject getSubject() {
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                if (ManagedConnectionFactoryDeployment.this.recoverUserName != null && ManagedConnectionFactoryDeployment.this.recoverPassword != null) {
                    Subject subject = new Subject();
                    SimplePrincipal p = new SimplePrincipal(ManagedConnectionFactoryDeployment.this.recoverUserName);
                    subject.getPrincipals().add((Principal)p);
                    PasswordCredential pc = new PasswordCredential(ManagedConnectionFactoryDeployment.this.recoverUserName, ManagedConnectionFactoryDeployment.this.recoverPassword.toCharArray());
                    pc.setManagedConnectionFactory(ManagedConnectionFactoryDeployment.this.mcf);
                    subject.getPrivateCredentials().add(pc);
                    if (ManagedConnectionFactoryDeployment.this.log.isDebugEnabled()) {
                        ManagedConnectionFactoryDeployment.this.log.debug((Object)("Recovery Subject=" + subject));
                    }
                    return subject;
                }
                try {
                    SecurityContext securityContext = SecurityContextFactory.createSecurityContext((String)ManagedConnectionFactoryDeployment.this.recoverSecurityDomain);
                    SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
                    Subject unauthenticated = new Subject();
                    securityContext.getSubjectInfo().setAuthenticatedSubject(unauthenticated);
                    String domain = ManagedConnectionFactoryDeployment.this.recoverSecurityDomain;
                    if (domain == null) {
                        domain = ManagedConnectionFactoryDeployment.this.securityDomain;
                    }
                    if (domain != null) {
                        Subject subject = ManagedConnectionFactoryDeployment.this.subjectFactory.createSubject(domain);
                        if (ManagedConnectionFactoryDeployment.this.log.isDebugEnabled()) {
                            ManagedConnectionFactoryDeployment.this.log.debug((Object)("Recovery Subject=" + subject));
                        }
                        return subject;
                    }
                    if (ManagedConnectionFactoryDeployment.this.log.isDebugEnabled()) {
                        ManagedConnectionFactoryDeployment.this.log.debug((Object)"RecoverySecurityDomain was empty");
                    }
                }
                catch (Throwable t) {
                    ManagedConnectionFactoryDeployment.this.log.debug((Object)("Exception during getSubject()" + t.getMessage()), t);
                }
                return null;
            }
        });
    }

    private ManagedConnection open(Subject s) throws ResourceException {
        if (this.recoverMC == null) {
            this.recoverMC = this.createManagedConnection(s, null);
        }
        return this.recoverMC;
    }

    private void close(ManagedConnection mc) {
        block7: {
            block6: {
                if (mc != null) {
                    try {
                        mc.cleanup();
                    }
                    catch (ResourceException ire) {
                        if (!this.log.isDebugEnabled()) break block6;
                        this.log.debug((Object)"Error during recovery cleanup", (Throwable)ire);
                    }
                }
            }
            if (mc != null) {
                try {
                    mc.destroy();
                }
                catch (ResourceException ire) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)"Error during recovery destroy", (Throwable)ire);
                }
            }
        }
        mc = null;
    }

    public void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value) {
        this.setManagedConnectionFactoryAttribute(name, clazz, value, false);
    }

    protected void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value, boolean mustExist) {
        Method setter;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Null or empty attribute name " + name);
        }
        String setterName = "set" + Character.toUpperCase(name.charAt(0));
        if (name.length() > 1) {
            setterName = setterName.concat(name.substring(1));
        }
        try {
            setter = this.mcfClass.getMethod(setterName, clazz);
        }
        catch (NoSuchMethodException nsme) {
            String error = "The class '" + this.mcfClass.toString() + "' has no setter for config property '" + name + "'";
            if (mustExist) {
                throw new IllegalArgumentException(error);
            }
            this.log.trace((Object)error, (Throwable)nsme);
            return;
        }
        try {
            setter.invoke((Object)this.mcf, value);
            this.log.debug((Object)("set property " + name + " to value " + value));
        }
        catch (Exception e) {
            String error = "Unable to invoke setter method '" + setter + "' " + "on object '" + this.mcf + "'";
            if (e instanceof InvocationTargetException) {
                throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
            }
            throw new NestedRuntimeException(error, (Throwable)e);
        }
        this.sendNotification(new Notification(MCF_ATTRIBUTE_CHANGED_NOTIFICATION, this.getServiceName(), this.getNextNotificationSequenceNumber()));
    }

    public Object getManagedConnectionFactoryAttribute(String name) {
        Method getter;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Null or empty attribute name " + name);
        }
        String getterName = "get" + Character.toUpperCase(name.charAt(0));
        if (name.length() > 1) {
            getterName = getterName.concat(name.substring(1));
        }
        try {
            getter = this.mcfClass.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "The class '" + this.mcfClass + "' has no getter(" + getterName + ") for config property '" + name + "'";
            this.log.debug((Object)msg, (Throwable)e);
            throw new IllegalArgumentException(msg);
        }
        try {
            Object value = getter.invoke((Object)this.mcf, new Object[0]);
            this.log.debug((Object)("get property " + name + ": value " + value));
            return value;
        }
        catch (Exception e) {
            String error = "Unable to invoke getter method '" + getter + "' " + "on object '" + this.mcf + "'";
            this.log.debug((Object)error, (Throwable)e);
            if (e instanceof InvocationTargetException) {
                throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
            }
            throw new NestedRuntimeException(error, (Throwable)e);
        }
    }

    protected void setMcfProperties(Collection properties, boolean mustExist) throws DeploymentException {
        for (ConfigPropertyMetaData cpmd : properties) {
            PropertyEditor pe;
            String name = cpmd.getName();
            String type = cpmd.getType();
            String value = cpmd.getValue();
            if (name == null || name.length() == 0 || value == null || value.length() == 0) {
                this.log.debug((Object)("Not setting config property '" + name + "'"));
                continue;
            }
            Class<?> clazz = Classes.getPrimitiveTypeForName((String)type);
            if (clazz == null) {
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.warn((Object)("Unable to find class '" + type + "' for " + "property '" + name + "' - skipping property."));
                    continue;
                }
            }
            if ((pe = PropertyEditorManager.findEditor(clazz)) == null) {
                this.log.warn((Object)("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + name + "' - " + "skipping property"));
                continue;
            }
            value = StringPropertyReplacer.replaceProperties((String)value);
            this.log.debug((Object)("setting property: " + name + " to value " + value));
            try {
                pe.setAsText(value);
            }
            catch (IllegalArgumentException iae) {
                this.log.warn((Object)("Value '" + value + "' is not valid for property '" + name + "' of class '" + clazz + "' - skipping " + "property"));
                continue;
            }
            Object v = pe.getValue();
            this.setManagedConnectionFactoryAttribute(name, clazz, v, mustExist);
        }
    }

    protected void setManagedConnectionFactoryProperties(List<ManagedConnectionFactoryPropertyMetaData> properties) {
        for (ManagedConnectionFactoryPropertyMetaData property : properties) {
            PropertyEditor pe;
            Class<?> clazz;
            String name = property.getName();
            String type = property.getType();
            String value = property.getValue();
            if (name == null || name.length() == 0 || value == null || value.length() == 0) {
                this.log.debug((Object)("Not setting config property '" + name + "'"));
                continue;
            }
            if (type == null || type.length() == 0) {
                type = "java.lang.String";
            }
            if ((clazz = Classes.getPrimitiveTypeForName((String)type)) == null) {
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.warn((Object)("Unable to find class '" + type + "' for " + "property '" + name + "' - skipping property."));
                    continue;
                }
            }
            if ((pe = PropertyEditorManager.findEditor(clazz)) == null) {
                this.log.warn((Object)("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + name + "' - " + "skipping property"));
                continue;
            }
            value = StringPropertyReplacer.replaceProperties((String)value);
            this.log.debug((Object)("setting property: " + name + " to value " + value));
            try {
                pe.setAsText(value);
            }
            catch (IllegalArgumentException iae) {
                this.log.warn((Object)("Value '" + value + "' is not valid for property '" + name + "' of class '" + clazz + "' - skipping " + "property"));
                continue;
            }
            Object v = pe.getValue();
            this.setManagedConnectionFactoryAttribute(name, clazz, v);
        }
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.mcf.createConnectionFactory();
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return this.mcf.createConnectionFactory(cxManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.mcf.createManagedConnection(subject, cxRequestInfo);
    }

    public boolean equals(Object other) {
        return this.mcf.equals(other);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.mcf.getLogWriter();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(((Object)((Object)this)).getClass().getName());
        buffer.append('@');
        buffer.append(Integer.toHexString(System.identityHashCode((Object)this)));
        return buffer.toString();
    }

    public int hashCode() {
        return this.mcf.hashCode();
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.mcf.matchManagedConnections(connectionSet, subject, cxRequestInfo);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.mcf.setLogWriter(out);
    }

    protected MBeanAttributeInfo[] getInternalAttributeInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        attributes.add(new MBeanAttributeInfo("RARName", String.class.getName(), "The ResourceAdapter deployment name.", true, false, false));
        attributes.add(new MBeanAttributeInfo("OldRarDeployment", ObjectName.class.getName(), "The Connection Defintion class name.", true, true, false));
        attributes.add(new MBeanAttributeInfo("ConnectionDefinition", String.class.getName(), "The Connection Defintion class name.", true, false, false));
        attributes.add(new MBeanAttributeInfo("VendorName", String.class.getName(), "The Vendor Name.", true, false, false));
        attributes.add(new MBeanAttributeInfo("SpecVersion", String.class.getName(), "The Specification Version.", true, false, false));
        attributes.add(new MBeanAttributeInfo("EisType", String.class.getName(), "The Enterprise Information System type.", true, false, false));
        attributes.add(new MBeanAttributeInfo("Version", String.class.getName(), "The ResourceAdapter version.", true, false, false));
        attributes.add(new MBeanAttributeInfo("ManagedConnectionFactoryClass", String.class.getName(), "The ManagedConnectionFactory class", true, false, false));
        attributes.add(new MBeanAttributeInfo("ConnectionFactoryImpl", String.class.getName(), "The Connection Factory implementation", true, false, false));
        attributes.add(new MBeanAttributeInfo("ConnectionInterface", String.class.getName(), "The Connection Inteface", true, false, false));
        attributes.add(new MBeanAttributeInfo("ConnectionImplClass", String.class.getName(), "The Connection Implementation class", true, false, false));
        attributes.add(new MBeanAttributeInfo("TransactionSupport", String.class.getName(), "The Transaction Support", true, false, false));
        attributes.add(new MBeanAttributeInfo("AuthenticationMechanismType", String.class.getName(), "The Authentication Mechanism Type", true, false, false));
        attributes.add(new MBeanAttributeInfo("CredentialInterface", String.class.getName(), "The Credential Interface", true, false, false));
        attributes.add(new MBeanAttributeInfo("ReauthenticationSupport", Boolean.class.getName(), "The Reauthentication Support", true, false, true));
        attributes.add(new MBeanAttributeInfo("McfInstance", "javax.resource.spi.ManagedConnectionFactory", "The ManagedConnectionFactory instance", true, false, false));
        attributes.add(new MBeanAttributeInfo("XAResourceRecoveryRegistry", XAResourceRecoveryRegistry.class.getName(), "The XAResource Recovery Registry", true, false, false));
        attributes.add(new MBeanAttributeInfo("SubjectFactory", SubjectFactory.class.getName(), "The subject factory used for recovery", true, false, false));
        attributes.add(new MBeanAttributeInfo("ConnectionManager", String.class.getName(), "The connection manager object name", true, false, false));
        MBeanAttributeInfo[] info = attributes.toArray(new MBeanAttributeInfo[attributes.size()]);
        return info;
    }

    protected void setInternalAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if ("OldRarDeployment".equals(attribute.getName())) {
            this.oldRarDeployment = (ObjectName)attribute.getValue();
        } else if ("XAResourceRecoveryRegistry".equals(attribute.getName())) {
            this.xrrr = (XAResourceRecoveryRegistry)attribute.getValue();
        } else if ("SubjectFactory".equals(attribute.getName())) {
            this.subjectFactory = (SubjectFactory)attribute.getValue();
        }
    }

    protected MBeanOperationInfo[] getInternalOperationInfo() {
        MBeanOperationInfo[] operations = new MBeanOperationInfo[1];
        MBeanParameterInfo[] getMCFAttributeParamInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("ManagedConnectionFactoryAttributeName", String.class.getName(), "The ManagedConnectionFactoryAttribute name")};
        operations[0] = new MBeanOperationInfo("getManagedConnectionFactoryAttribute", "Inspect the value of a ManagedConnectionFactory attribute", getMCFAttributeParamInfo, Object.class.getName(), 0);
        return operations;
    }

    protected Object internalInvoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equals("getManagedConnectionFactoryAttribute")) {
            String param = (String)params[0];
            return this.getManagedConnectionFactoryAttribute(param);
        }
        return super.internalInvoke(actionName, params, signature);
    }

    protected Object getInternalAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ConnectionDefinitionMetaData cdmd = this.cmd.getConnectionDefinition(this.dmd.getConnectionDefinition());
        Object result = null;
        if ("RARName".equals(attribute)) {
            result = this.rarName;
        } else if ("OldRarDeployment".equals(attribute)) {
            result = this.oldRarDeployment;
        } else if ("ConnectionDefinition".equals(attribute)) {
            result = this.dmd.getConnectionDefinition();
        } else if ("VendorName".equals(attribute)) {
            result = this.cmd.getVendorName();
        } else if ("SpecVersion".equals(attribute)) {
            result = this.cmd.getVersion();
        } else if ("EisType".equals(attribute)) {
            result = this.cmd.getEISType();
        } else if ("Version".equals(attribute)) {
            result = this.cmd.getRAVersion();
        } else if ("ManagedConnectionFactoryClass".equals(attribute)) {
            result = cdmd.getManagedConnectionFactoryClass();
        } else if ("ConnectionInterface".equals(attribute)) {
            result = cdmd.getConnectionInterfaceClass();
        } else if ("ConnectionFactoryImpl".equals(attribute)) {
            result = cdmd.getConnectionFactoryImplementationClass();
        } else if ("ConnectionImplClass".equals(attribute)) {
            result = cdmd.getConnectionImplementationClass();
        } else if ("TransactionSupport".equals(attribute)) {
            result = this.dmd.getTransactionSupportMetaData();
        } else if ("AuthenticationMechanismType".equals(attribute)) {
            result = this.cmd.getAuthenticationMechanism().getAuthenticationMechansimType();
        } else if ("CredentialInterface".equals(attribute)) {
            result = this.cmd.getAuthenticationMechanism().getCredentialInterfaceClass();
        } else if ("ReauthenticationSupport".equals(attribute)) {
            result = this.cmd.getReauthenticationSupport();
        } else if ("McfInstance".equals(attribute)) {
            result = this.mcf;
        } else if ("XAResourceRecoveryRegistry".equals(attribute)) {
            result = this.xrrr;
        } else if ("SubjectFactory".equals(attribute)) {
            result = this.subjectFactory;
        } else if ("ConnectionManager".equals(attribute)) {
            result = this.connectionManager;
        }
        if (result == null) {
            result = super.getInternalAttribute(attribute);
        }
        return result;
    }

    protected String getInternalDescription() {
        String description = null;
        DescriptionGroupMetaData dgmd = this.cmd.getDescription();
        if (dgmd != null) {
            description = dgmd.getDescription();
        }
        if (description == null) {
            description = "RAR Deployment ";
        }
        return description;
    }
}

