/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.work;

import java.util.concurrent.CountDownLatch;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.resource.work.JBossWorkManager;

public class WorkWrapper
implements Runnable {
    private static Logger log = Logger.getLogger(WorkWrapper.class);
    private static boolean trace = log.isTraceEnabled();
    private Work work;
    private ExecutionContext executionContext;
    private WorkListener workListener;
    private JBossWorkManager workManager;
    private long blockedTime;
    private WorkException exception;
    private CountDownLatch startedLatch;
    private CountDownLatch completedLatch;

    public WorkWrapper(JBossWorkManager workManager, Work work, ExecutionContext executionContext, WorkListener workListener, CountDownLatch startedLatch, CountDownLatch completedLatch) {
        if (work == null) {
            throw new IllegalArgumentException("Null work");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("Null execution context");
        }
        this.workManager = workManager;
        this.work = work;
        this.executionContext = executionContext;
        this.workListener = workListener;
        this.startedLatch = startedLatch;
        this.completedLatch = completedLatch;
    }

    public JBossWorkManager getWorkManager() {
        return this.workManager;
    }

    public Work getWork() {
        return this.work;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public WorkException getWorkException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (trace) {
            log.trace((Object)("Starting work " + this));
        }
        try {
            this.start();
            if (this.startedLatch != null) {
                this.startedLatch.countDown();
            }
            this.work.run();
            this.end();
        }
        catch (Exception e) {
            this.exception = new WorkCompletedException((Throwable)e);
            this.cancel();
        }
        finally {
            this.work.release();
            if (this.workListener != null) {
                WorkEvent event = new WorkEvent((Object)this.workManager, 4, this.work, this.exception);
                this.workListener.workCompleted(event);
            }
            if (this.startedLatch != null) {
                while (this.startedLatch.getCount() != 0L) {
                    this.startedLatch.countDown();
                }
            }
            if (this.completedLatch != null) {
                this.completedLatch.countDown();
            }
            if (trace) {
                log.trace((Object)("Executed work " + this));
            }
        }
    }

    protected void start() throws WorkException {
        Xid xid;
        ExecutionContext ctx;
        if (trace) {
            log.trace((Object)("Starting work " + this));
        }
        if ((ctx = this.getExecutionContext()) != null && (xid = ctx.getXid()) != null) {
            long timeout = ctx.getTransactionTimeout() * 1000L;
            this.workManager.getXATerminator().registerWork(this.work, xid, timeout);
        }
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().startWork(this.work, xid);
        }
        if (this.workListener != null) {
            WorkEvent event = new WorkEvent((Object)this.workManager, 3, this.work, null);
            this.workListener.workStarted(event);
        }
        if (trace) {
            log.trace((Object)("Started work " + this));
        }
    }

    protected void end() {
        Xid xid;
        ExecutionContext ctx;
        if (trace) {
            log.trace((Object)("Ending work " + this));
        }
        if ((ctx = this.getExecutionContext()) != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().endWork(this.work, xid);
        }
        if (trace) {
            log.trace((Object)("Ended work " + this));
        }
    }

    protected void cancel() {
        Xid xid;
        ExecutionContext ctx;
        if (trace) {
            log.trace((Object)("Cancel work " + this));
        }
        if ((ctx = this.getExecutionContext()) != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().cancelWork(this.work, xid);
        }
        if (trace) {
            log.trace((Object)("Canceled work " + this));
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("WorkWrapper@").append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append("[workManger=").append(this.workManager);
        buffer.append(" work=").append(this.work);
        if (this.executionContext != null && this.executionContext.getXid() != null) {
            buffer.append(" xid=").append(this.executionContext.getXid());
            buffer.append(" txTimeout=").append(this.executionContext.getTransactionTimeout());
        }
        if (this.workListener != null) {
            buffer.append(" workListener=").append(this.workListener);
        }
        if (this.exception != null) {
            buffer.append(" exception=").append(this.exception);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

