/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component.behavior;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior._AjaxBehaviorDeltaStateHelper;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxBehavior
extends ClientBehaviorBase {
    public static final String BEHAVIOR_ID = "javax.faces.behavior.Ajax";
    private static final String ATTR_EXECUTE = "execute";
    private static final String ATTR_ON_ERROR = "onerror";
    private static final String ATTR_ON_EVENT = "onevent";
    private static final String ATTR_RENDER = "render";
    private static final String ATTR_DISABLED = "disabled";
    private static final String ATTR_IMMEDIATE = "immediate";
    private static final String VAL_FORM = "@form";
    private static final String VAL_ALL = "@all";
    private static final String VAL_THIS = "@this";
    private static final String VAL_NONE = "@none";
    private static final Collection<String> VAL_FORM_LIST = Collections.singletonList("@form");
    private static final Collection<String> VAL_ALL_LIST = Collections.singletonList("@all");
    private static final Collection<String> VAL_THIS_LIST = Collections.singletonList("@this");
    private static final Collection<String> VAL_NONE_LIST = Collections.singletonList("@none");
    private _AjaxBehaviorDeltaStateHelper<AjaxBehavior> deltaStateHelper = new _AjaxBehaviorDeltaStateHelper<AjaxBehavior>(this);
    private Map<String, ValueExpression> _valueExpressions = new HashMap<String, ValueExpression>();

    public void addAjaxBehaviorListener(AjaxBehaviorListener listener) {
        super.addBehaviorListener(listener);
    }

    public void removeAjaxBehaviorListener(AjaxBehaviorListener listener) {
        this.removeBehaviorListener(listener);
    }

    public Collection<String> getExecute() {
        return this.evalForCollection(ATTR_EXECUTE);
    }

    public void setExecute(Collection<String> execute) {
        this.deltaStateHelper.put((Serializable)((Object)ATTR_EXECUTE), execute);
    }

    public String getOnerror() {
        return (String)this.deltaStateHelper.eval((Serializable)((Object)ATTR_ON_ERROR));
    }

    public void setOnerror(String onError) {
        this.deltaStateHelper.put((Serializable)((Object)ATTR_ON_ERROR), onError);
    }

    public String getOnevent() {
        return (String)this.deltaStateHelper.eval((Serializable)((Object)ATTR_ON_EVENT));
    }

    public void setOnevent(String onEvent) {
        this.deltaStateHelper.put((Serializable)((Object)ATTR_ON_EVENT), onEvent);
    }

    public Collection<String> getRender() {
        return this.evalForCollection(ATTR_RENDER);
    }

    public void setRender(Collection<String> render) {
        this.deltaStateHelper.put((Serializable)((Object)ATTR_RENDER), render);
    }

    public ValueExpression getValueExpression(String name) {
        return this.getValueExpressionMap().get(name);
    }

    public void setValueExpression(String name, ValueExpression item) {
        if (item == null) {
            this.getValueExpressionMap().remove(name);
            this.deltaStateHelper.remove((Serializable)((Object)name));
        } else {
            this.getValueExpressionMap().put(name, item);
        }
    }

    public boolean isDisabled() {
        Boolean retVal = (Boolean)this.deltaStateHelper.eval((Serializable)((Object)ATTR_DISABLED));
        retVal = retVal == null ? false : retVal;
        return retVal;
    }

    public void setDisabled(boolean disabled) {
        this.deltaStateHelper.put((Serializable)((Object)ATTR_DISABLED), disabled);
    }

    public boolean isImmediate() {
        Boolean retVal = (Boolean)this.deltaStateHelper.eval((Serializable)((Object)ATTR_IMMEDIATE));
        retVal = retVal == null ? false : retVal;
        return retVal;
    }

    public void setImmediate(boolean immediate) {
        this.deltaStateHelper.put((Serializable)((Object)ATTR_IMMEDIATE), immediate);
    }

    public boolean isImmediateSet() {
        return this.deltaStateHelper.eval((Serializable)((Object)ATTR_IMMEDIATE)) != null;
    }

    @Override
    public Set<ClientBehaviorHint> getHints() {
        return EnumSet.of(ClientBehaviorHint.SUBMITTING);
    }

    @Override
    public String getRendererType() {
        return BEHAVIOR_ID;
    }

    @Override
    public void restoreState(FacesContext facesContext, Object o) {
        if (o == null) {
            return;
        }
        Object[] values = (Object[])o;
        if (values[0] != null) {
            super.restoreState(facesContext, values[0]);
        }
        this.deltaStateHelper.restoreState(facesContext, values[1]);
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        if (this.initialStateMarked()) {
            Object parentSaved = super.saveState(facesContext);
            Object deltaStateHelperSaved = this.deltaStateHelper.saveState(facesContext);
            if (parentSaved == null && deltaStateHelperSaved == null) {
                return null;
            }
            return new Object[]{parentSaved, deltaStateHelperSaved};
        }
        Object[] values = new Object[]{super.saveState(facesContext), this.deltaStateHelper.saveState(facesContext)};
        return values;
    }

    private Map<String, ValueExpression> getValueExpressionMap() {
        return this._valueExpressions;
    }

    private Collection<String> evalForCollection(String attributeName) {
        Object value = this.deltaStateHelper.eval((Serializable)((Object)attributeName));
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof String) {
            return this.getCollectionFromSpaceSplitString((String)value);
        }
        throw new IllegalArgumentException("Type " + value.getClass() + " not supported for attribute " + attributeName);
    }

    private Collection<String> getCollectionFromSpaceSplitString(String stringValue) {
        if (stringValue.equals(VAL_FORM)) {
            return VAL_FORM_LIST;
        }
        if (stringValue.equals(VAL_ALL)) {
            return VAL_ALL_LIST;
        }
        if (stringValue.equals(VAL_NONE)) {
            return VAL_NONE_LIST;
        }
        if (stringValue.equals(VAL_THIS)) {
            return VAL_THIS_LIST;
        }
        String[] arrValue = stringValue.split(" ");
        return Arrays.asList(arrValue);
    }
}

