/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.jndi;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;

public abstract class AbstractNoInterfaceViewBinder {
    private static Logger logger = Logger.getLogger(AbstractNoInterfaceViewBinder.class);
    protected KernelControllerContext endpointContext;
    protected Class<?> beanClass;
    protected JBossSessionBean31MetaData sessionBeanMetaData;
    protected Context jndiContext;
    protected String noInterfaceViewJNDIName;

    public AbstractNoInterfaceViewBinder(Context jndiCtx, String jndiName, Class<?> beanClass, JBossSessionBean31MetaData beanMetaData) {
        if (!beanMetaData.isNoInterfaceBean()) {
            throw new IllegalStateException(beanMetaData.getEjbName() + " bean does not have a no-interface view");
        }
        this.beanClass = beanClass;
        this.noInterfaceViewJNDIName = jndiName;
        this.sessionBeanMetaData = beanMetaData;
        this.jndiContext = jndiCtx;
    }

    public void start() throws Exception {
        this.bind();
    }

    public void stop() throws Exception {
        this.unbind();
    }

    protected abstract void bind() throws NamingException;

    protected abstract void unbind() throws NamingException;

    protected void prettyPrintJNDIBindingInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Binding the following entry in Global JNDI for bean:" + this.sessionBeanMetaData.getEjbName() + "\n\n");
        sb.append("\t");
        sb.append(this.noInterfaceViewJNDIName);
        sb.append(" -> EJB3.1 no-interface view\n");
        logger.info((Object)sb);
    }

    public void setEndpointContext(KernelControllerContext endpointContext) throws Exception {
        this.endpointContext = endpointContext;
    }
}

