/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.objectfactory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.ejb3.nointerface.impl.view.factory.StatefulNoInterfaceViewProxyFactory;
import org.jboss.logging.Logger;

public class StatefulNoInterfaceViewObjectFactory
implements ObjectFactory {
    private static Logger logger = Logger.getLogger(StatefulNoInterfaceViewObjectFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating object instance through object instance factory for name " + name));
        }
        logger.debug((Object)("Creating object instance through object instance factory for name " + name));
        assert (obj instanceof Reference) : StatefulNoInterfaceViewObjectFactory.class + " cannot create view from obj of type " + obj.getClass().getName();
        Reference reference = (Reference)obj;
        String jndiNameOfStatefulProxyFactory = this.getProxyFactoryJNDINameFromReference(reference);
        assert (jndiNameOfStatefulProxyFactory != null) : "Stateful proxy factory for creating no-interface view, not found in reference";
        Object proxyFactory = nameCtx.lookup(jndiNameOfStatefulProxyFactory);
        assert (proxyFactory instanceof StatefulNoInterfaceViewProxyFactory) : "Unexpected type found at jndi name " + jndiNameOfStatefulProxyFactory + " Expected type " + StatefulNoInterfaceViewProxyFactory.class.getName();
        StatefulNoInterfaceViewProxyFactory noInterfaceViewFactory = (StatefulNoInterfaceViewProxyFactory)proxyFactory;
        return noInterfaceViewFactory.createNoInterfaceView();
    }

    protected String getProxyFactoryJNDINameFromReference(Reference ref) {
        RefAddr refAddr = ref.get("Stateful Proxy factory for no-interface view");
        Object jndiNameOfStatefulProxyFactory = refAddr.getContent();
        assert (jndiNameOfStatefulProxyFactory instanceof String) : "Unexpected type for Stateful Proxy factory for no-interface view";
        return (String)jndiNameOfStatefulProxyFactory;
    }
}

