/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.List;
import java.util.Map;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.portableInterceptor.IORInfoExt;
import org.jacorb.poa.POA;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.ETF.Profile;
import org.omg.IOP.TaggedComponent;

public class IORInfoImpl
extends LocalObject
implements IORInfoExt {
    private final Map components;
    private final Map policy_overrides;
    private final ORB orb;
    private final POA poa;
    private final List _profiles;

    public IORInfoImpl(ORB oRB, POA pOA, Map map, Map map2, List list) {
        this.orb = oRB;
        this.poa = pOA;
        this.components = map;
        this.policy_overrides = map2;
        this._profiles = list;
    }

    public void add_ior_component(TaggedComponent taggedComponent) {
        for (TaggedComponentList taggedComponentList : this.components.values()) {
            taggedComponentList.addComponent(taggedComponent);
        }
    }

    public void add_ior_component_to_profile(TaggedComponent taggedComponent, int n) {
        TaggedComponentList taggedComponentList = (TaggedComponentList)this.components.get(new Integer(n));
        if (taggedComponentList == null) {
            throw new BAD_PARAM("unknown profile tag: " + n, 29, CompletionStatus.COMPLETED_MAYBE);
        }
        taggedComponentList.addComponent(taggedComponent);
    }

    public Policy get_effective_policy(int n) {
        if (!this.orb.hasPolicyFactoryForType(n)) {
            throw new INV_POLICY("No PolicyFactory for type " + n + " has been registered!", 3, CompletionStatus.COMPLETED_MAYBE);
        }
        Policy policy = null;
        if (this.policy_overrides != null) {
            policy = (Policy)this.policy_overrides.get(new Integer(n));
        }
        return policy != null ? policy : this.poa.getPolicy(n);
    }

    public void add_profile(Profile profile) {
        if (this._profiles != null) {
            this._profiles.add(profile);
        }
    }

    public int get_number_of_profiles(int n) {
        int n2 = 0;
        for (int i = 0; i < this._profiles.size(); ++i) {
            Profile profile = (Profile)this._profiles.get(i);
            if (profile.tag() != n) continue;
            ++n2;
        }
        return n2;
    }

    public Profile get_profile(int n, int n2) {
        int n3 = n2;
        Profile profile = null;
        for (int i = 0; i < this._profiles.size(); ++i) {
            Profile profile2 = (Profile)this._profiles.get(i);
            if (profile2.tag() == n && n3 == 0) {
                profile = profile2;
                break;
            }
            --n3;
        }
        if (profile == null) {
            throw new ArrayIndexOutOfBoundsException("no profile with tag=" + n + " at position" + n2);
        }
        return profile;
    }

    public Profile get_profile(int n) {
        Profile profile = null;
        for (int i = 0; i < this._profiles.size(); ++i) {
            Profile profile2 = (Profile)this._profiles.get(i);
            if (profile2.tag() != n) continue;
            profile = profile2;
            break;
        }
        return profile;
    }
}

