/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.hibernate.validator.Digits;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigitsValidator
implements Validator<Digits>,
PropertyConstraint {
    int integerDigits;
    int fractionalDigits;

    @Override
    public void initialize(Digits configuration) {
        this.integerDigits = configuration.integerDigits();
        this.fractionalDigits = configuration.fractionalDigits();
    }

    @Override
    public boolean isValid(Object value) {
        int right;
        String stringValue;
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            try {
                stringValue = this.stringValue(new BigDecimal((String)value));
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        } else if (value instanceof BigDecimal) {
            stringValue = this.stringValue((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            stringValue = this.stringValue((BigInteger)value);
        } else if (value instanceof Number) {
            stringValue = this.stringValue(new BigDecimal(((Number)value).toString()));
        } else {
            return false;
        }
        int pos = stringValue.indexOf(".");
        int left = pos == -1 ? stringValue.length() : pos;
        int n = right = pos == -1 ? 0 : stringValue.length() - pos - 1;
        if (left == 1 && stringValue.charAt(0) == '0') {
            --left;
        }
        return left <= this.integerDigits && right <= this.fractionalDigits;
    }

    private String stringValue(BigDecimal number) {
        return number.abs().stripTrailingZeros().toPlainString();
    }

    private String stringValue(BigInteger number) {
        return number.abs().toString();
    }

    @Override
    public void apply(Property property) {
        Column col = (Column)property.getColumnIterator().next();
        col.setPrecision(this.integerDigits + this.fractionalDigits);
        col.setScale(this.fractionalDigits);
    }
}

