/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.manager;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceResponse;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ResourceManager {
    public static final String RESOURCE_CREATED_EVENT = "resourceCreated";
    public static final String RESOURCE_UPDATED_EVENT = "resourceUpdated";
    public static final String RESOURCE_DELETED_EVENT = "resourceDeleted";
    public static final String NAV_TREE_INITIALIZED = "navTreeInitialized";

    public void discoverResources();

    public void discoverServicesAsync();

    public void discoverServicesSync();

    @Nullable
    public ResourceType getResourceType(String var1);

    public Set<ResourceType> getAllResourceTypes();

    @NotNull
    public Set<Resource> getResources(ResourceType var1, Resource var2);

    @Nullable
    public Resource getResource(Integer var1);

    public Configuration getResourceConfiguration(Resource var1);

    public DeleteResourceResponse removeResource(Resource var1);

    public CreateResourceResponse createResource(String var1, ResourceType var2, Resource var3, Configuration var4, Configuration var5);

    public CreateResourceResponse createResource(String var1, ResourceType var2, Resource var3, Configuration var4, ResourcePackageDetails var5);

    public ConfigurationUpdateResponse updateResource(Resource var1, Configuration var2);

    public Availability getAvailability(Resource var1);

    public List<OperationDefinition> getOperationsForResource(Resource var1);

    public void invokeOperation(Resource var1, OperationDefinition var2, Configuration var3, String var4);

    public Resource getPlatform();
}

