/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import org.jboss.on.embedded.bean.MeasurementDisplay;
import org.jboss.on.embedded.bean.MeasurementUtils;
import org.jboss.on.embedded.bean.ResourceListItem;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.NavigationAction;
import org.jboss.on.embedded.ui.nav.BaseTreeNode;
import org.jboss.on.embedded.ui.nav.JONTreeNode;
import org.jboss.on.embedded.ui.nav.NonSingletonResourceTypeTreeNode;
import org.jboss.on.embedded.ui.nav.SubCategoryTreeNode;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="summaryAction")
@Scope(value=ScopeType.EVENT)
public class SummaryAction {
    @In
    private transient FacesMessages facesMessages;
    @Out(required=false, scope=ScopeType.PAGE)
    private SubCategoryTreeNode subCategory;
    @Out(required=false, scope=ScopeType.PAGE)
    private ResourceType resourceType;
    @Out(required=false)
    private ResourceListItem currentResource;
    @Out(required=false)
    private List<MeasurementDisplay> summaryMeasurementDisplayList;
    @Out(required=false)
    Map<String, MeasurementDefinition> summaryMeasurementDefinitionMap;
    @Out(required=false)
    private List<MeasurementDisplay> summaryTraitDisplayList;
    @Out(required=false, scope=ScopeType.PAGE)
    private List<ResourceListItem> resources;
    @In(value="#{navigationAction}")
    private NavigationAction navigationAction;
    private String resourceTypeFilter;

    public String view() {
        JONTreeNode selectedNode = this.navigationAction.getSelectedNode();
        return selectedNode.getSummaryActionOutcome(this).getOutcome();
    }

    private String addResourcesToList(String outcome, SubCategoryTreeNode selectedNode) {
        this.resources = new ArrayList<ResourceListItem>();
        for (JONTreeNode childNode : selectedNode.getChildNodes()) {
            if (childNode instanceof NonSingletonResourceTypeTreeNode) {
                NonSingletonResourceTypeTreeNode nonSingletonNode = (NonSingletonResourceTypeTreeNode)childNode;
                ResourceType resourceType = nonSingletonNode.getResourceType();
                if (this.resourceTypeFilter != null && !this.resourceTypeFilter.equals("All Types") && !this.resourceTypeFilter.equals(resourceType.getName())) continue;
                this.resources.addAll(this.getResourceListByType(resourceType, selectedNode.getClosestResource()));
                continue;
            }
            outcome = "repeatNav";
            this.resources.clear();
            break;
        }
        return outcome;
    }

    public String getResourceTypePath(String resourceTypeName) {
        JONTreeNode treeNode = ((BaseTreeNode)this.navigationAction.getRootNode()).findNodeByTypeName(resourceTypeName);
        return treeNode.getPath();
    }

    @NotNull
    public void setResourceAndSummaryInfo(Resource selectedResource) {
        List<MeasurementData> traitDataList;
        Availability availability = ResourceManagerFactory.resourceManager().getAvailability(selectedResource);
        this.currentResource = new ResourceListItem(selectedResource, availability);
        this.resourceType = selectedResource.getResourceType();
        this.summaryMeasurementDisplayList = new ArrayList<MeasurementDisplay>();
        MeasurementUtils measurementUtils = new MeasurementUtils(this.currentResource);
        this.summaryMeasurementDefinitionMap = measurementUtils.getMeasurementDefinitionMap();
        List<MeasurementData> measurementDataList = measurementUtils.loadMeasurementData(DisplayType.SUMMARY, DataType.MEASUREMENT);
        if (measurementDataList != null) {
            for (MeasurementData measurementData : measurementDataList) {
                MeasurementDefinition measurementDefinition = this.summaryMeasurementDefinitionMap.get(measurementData.getName());
                this.summaryMeasurementDisplayList.add(measurementUtils.createMeasurementDisplay(measurementData, measurementDefinition));
            }
        }
        if ((traitDataList = measurementUtils.loadMeasurementData(DisplayType.SUMMARY, DataType.TRAIT)) != null) {
            this.summaryTraitDisplayList = new ArrayList<MeasurementDisplay>();
            for (MeasurementData traitData : traitDataList) {
                this.summaryTraitDisplayList.add(measurementUtils.createMeasurementDisplay(traitData, this.summaryMeasurementDefinitionMap.get(traitData.getName())));
            }
        }
    }

    private List<ResourceListItem> getResourceListByType(ResourceType resourceType, Resource parentResource) {
        ResourceManager manager = ResourceManagerFactory.resourceManager();
        Set<Resource> resources = manager.getResources(resourceType, parentResource);
        ArrayList<ResourceListItem> items = new ArrayList<ResourceListItem>();
        for (Resource r : resources) {
            Availability availability = manager.getAvailability(r);
            ResourceListItem item = new ResourceListItem(r, availability);
            items.add(item);
        }
        return items;
    }

    public SubCategoryTreeNode getSubCategoryNode() {
        return this.subCategory;
    }

    public NavigationAction getNavigationAction() {
        return this.navigationAction;
    }

    public void setNavigationAction(NavigationAction navigationAction) {
        this.navigationAction = navigationAction;
    }

    public void resourceTypeSelected(ValueChangeEvent event) {
        Object newValue = event.getNewValue();
        if (newValue instanceof String) {
            this.resourceTypeFilter = (String)newValue;
            this.resourceTypeFilter = this.resourceTypeFilter.substring(this.resourceTypeFilter.lastIndexOf("/") + 1, this.resourceTypeFilter.length());
            JONTreeNode selectedNode = this.navigationAction.getSelectedNode();
            if (selectedNode instanceof SubCategoryTreeNode) {
                SubCategoryTreeNode subCatTreeNode = (SubCategoryTreeNode)selectedNode;
                this.addResourcesToList("", subCatTreeNode);
                this.subCategory = subCatTreeNode;
            }
        }
        FacesContext.getCurrentInstance().renderResponse();
    }

    public class SubCategoryOutcome
    implements SummaryActionOutcome {
        private SubCategoryTreeNode selectedNode;

        public SubCategoryOutcome(SubCategoryTreeNode node) {
            this.selectedNode = node;
        }

        public String getOutcome() {
            String outcome = "repeatNav";
            if (!this.selectedNode.isLeaf()) {
                outcome = "subCategory";
                outcome = SummaryAction.this.addResourcesToList(outcome, this.selectedNode);
            }
            SummaryAction.this.subCategory = this.selectedNode;
            return outcome;
        }
    }

    public class NonSingletonResourceTypeOutcome
    implements SummaryActionOutcome {
        private ResourceType resourceType;
        private Resource parentResource;

        public NonSingletonResourceTypeOutcome(ResourceType resType, Resource parentResource) {
            this.resourceType = resType;
            this.parentResource = parentResource;
        }

        public String getOutcome() {
            SummaryAction.this.resourceType = this.resourceType;
            SummaryAction.this.resources = SummaryAction.this.getResourceListByType(this.resourceType, this.parentResource);
            return "resourceSummary";
        }
    }

    public class ResourceOutcome
    implements SummaryActionOutcome {
        private Resource resource;

        public ResourceOutcome(Resource resource) {
            this.resource = resource;
        }

        public String getOutcome() {
            ResourceManager resourceManager = ResourceManagerFactory.resourceManager();
            if (resourceManager.getResource(this.resource.getId()) == null) {
                SummaryAction.this.facesMessages.add(FacesMessage.SEVERITY_WARN, "#0 '#1' no longer exists.", new Object[]{this.resource.getResourceType().getName(), this.resource.getName()});
                JONTreeNode parentNode = SummaryAction.this.navigationAction.getSelectedNode().getParent();
                SummaryAction.this.navigationAction.setCurrentPath(parentNode.getPath());
                parentNode.reInitializeChildrenMap();
                return "error";
            }
            SummaryAction.this.setResourceAndSummaryInfo(this.resource);
            return "resourceInstance";
        }
    }

    public static interface SummaryActionOutcome {
        public String getOutcome();
    }
}

