/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.as.config;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;

class SecurityActions {
    private static final Logger log = Logger.getLogger(SecurityActions.class);

    private SecurityActions() {
    }

    static String getEnvironmentVariable(final String key) throws IllegalArgumentException {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Key is a required argument");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String value = System.getenv(key);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Obtained Environment Variable with key \"" + key + "\": " + value));
                }
                return value;
            }
        });
    }
}

