/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.jboss.remoting.samples.chat.client.ChatInfo;
import org.jboss.remoting.samples.chat.client.ChatMember;
import org.jboss.remoting.samples.chat.client.Closeable;
import org.jboss.remoting.samples.chat.client.CloseableFrame;
import org.jboss.remoting.samples.chat.client.DummyListConnectionStrategy;
import org.jboss.remoting.samples.chat.client.ListConnectionStrategy;
import org.jboss.remoting.samples.chat.client.ListFrame_closeButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.ListFrame_exitButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.ListFrame_getInfoButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.ListFrame_joinButton_actionAdapter;
import org.jboss.remoting.samples.chat.exceptions.ConnectionException;
import org.jboss.remoting.samples.chat.exceptions.ListConnectionException;

public class ListFrame
extends CloseableFrame {
    JButton joinButton = new JButton();
    JButton getInfoButton = new JButton();
    JButton closeButton = new JButton();
    JButton exitButton = new JButton();
    private ListConnectionStrategy lcs;
    private ArrayList chatRoomInfo;
    JScrollPane jScrollPane1 = new JScrollPane();
    JList chatRoomList = new JList();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public ListFrame(ListConnectionStrategy lcs, ArrayList chatRoomInfo, Closeable parent) {
        super(parent);
        this.chatRoomInfo = chatRoomInfo;
        this.lcs = lcs;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.joinButton.setFont(new Font("SansSerif", 1, 12));
        this.joinButton.setMaximumSize(new Dimension(77, 25));
        this.joinButton.setMinimumSize(new Dimension(77, 25));
        this.joinButton.setText("Join");
        this.joinButton.addActionListener(new ListFrame_joinButton_actionAdapter(this));
        this.getInfoButton.setText("Get info");
        this.getInfoButton.addActionListener(new ListFrame_getInfoButton_actionAdapter(this));
        this.getInfoButton.setFont(new Font("SansSerif", 1, 12));
        this.getInfoButton.setMinimumSize(new Dimension(77, 25));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ListFrame_closeButton_actionAdapter(this));
        this.closeButton.setFont(new Font("SansSerif", 1, 12));
        this.closeButton.setMaximumSize(new Dimension(77, 25));
        this.closeButton.setMinimumSize(new Dimension(77, 25));
        this.closeButton.setFocusPainted(true);
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ListFrame_exitButton_actionAdapter(this));
        this.exitButton.setFont(new Font("SansSerif", 1, 12));
        this.exitButton.setMaximumSize(new Dimension(77, 25));
        this.exitButton.setMinimumSize(new Dimension(77, 25));
        this.setTitle("Current chat rooms");
        this.chatRoomList = this.makeChatRoomList(this.chatRoomInfo);
        this.chatRoomList.setSelectionMode(0);
        this.getContentPane().add((Component)this.exitButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(36, 7, 22, 11), 40, 0));
        this.getContentPane().add((Component)this.closeButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(35, 21, 22, 0), 16, 0));
        this.getContentPane().add((Component)this.joinButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(36, 9, 22, 0), 32, 0));
        this.getContentPane().add((Component)this.getInfoButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(33, 6, 22, 0), 0, 4));
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(57, 21, 0, 12), -106, 27));
        this.jScrollPane1.getViewport().add((Component)this.chatRoomList, null);
        this.pack();
        this.center();
    }

    protected JList makeChatRoomList(ArrayList chatRoomInfo) {
        String[] chats = new String[chatRoomInfo.size()];
        for (int i = 0; i < chatRoomInfo.size(); ++i) {
            chats[i] = ((ChatInfo)chatRoomInfo.get(i)).get_description();
            if (!chats[i].equals("")) continue;
            chats[i] = "*no name*";
        }
        JList<String> chatList = new JList<String>(chats);
        chatList.setSelectedIndex(0);
        return chatList;
    }

    public static void main(String[] args) {
        try {
            ChatMember chatMember0 = new ChatMember();
            ChatMember chatMember1 = new ChatMember();
            ChatMember chatMember2 = new ChatMember();
            chatMember0.set_name("m1");
            chatMember1.set_name("m2");
            chatMember2.set_name("m3");
            ChatInfo chatInfo0 = new ChatInfo();
            ChatInfo chatInfo1 = new ChatInfo();
            ChatInfo chatInfo2 = new ChatInfo();
            chatInfo0.set_currentMembers(0);
            chatInfo0.set_description("Lord of the Rings");
            chatInfo0.set_owner(chatMember0);
            chatInfo1.set_currentMembers(1);
            chatInfo1.set_description("Cat's Cradle");
            chatInfo1.set_owner(chatMember1);
            chatInfo2.set_currentMembers(2);
            chatInfo2.set_description("Siddhartha");
            chatInfo2.set_owner(chatMember2);
            ArrayList<ChatInfo> chats = new ArrayList<ChatInfo>(3);
            chats.add(chatInfo0);
            chats.add(chatInfo1);
            chats.add(chatInfo2);
            ListFrame frame = new ListFrame(new DummyListConnectionStrategy(), chats, null);
            frame.show();
        }
        catch (ListConnectionException lce) {
            System.out.println("ListFrameTest: unable to create chat frame");
        }
    }

    void joinButton_actionPerformed(ActionEvent e) {
        try {
            this.notifyOnClose(this);
            if (this.chatRoomList.getModel().getSize() <= this.chatRoomList.getSelectedIndex()) {
                System.out.println("there are no chat rooms to join");
                return;
            }
            ChatInfo chatInfo = (ChatInfo)this.chatRoomInfo.get(this.chatRoomList.getSelectedIndex());
            this.lcs.getId(chatInfo);
        }
        catch (ConnectionException ce) {
            System.out.println("Join button catches exception:");
            System.out.println(ce);
        }
    }

    void getInfoButton_actionPerformed(ActionEvent e) {
        try {
            this.notifyOnClose(this);
            if (this.chatRoomList.getModel().getSize() <= this.chatRoomList.getSelectedIndex()) {
                System.out.println("there are no chat rooms");
                return;
            }
            this.lcs.getInfo(this.chatRoomInfo, this.chatRoomList.getSelectedIndex());
        }
        catch (ListConnectionException lce) {
            System.out.println("Info button catches exception:");
            System.out.println(lce);
        }
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.notifyOnClose(this);
    }

    void exitButton_actionPerformed(ActionEvent e) {
        System.exit(0);
    }
}

