/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.sslsocket;

import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transport.socket.SocketServerInvoker;
import org.jboss.remoting.transport.sslsocket.SSLSocketServerInvokerMBean;

public class SSLSocketServerInvoker
extends SocketServerInvoker
implements SSLSocketServerInvokerMBean {
    private static final Logger log = Logger.getLogger(SSLSocketServerInvoker.class);
    protected String[] enabledCipherSuites;
    protected String[] enabledProtocols;
    protected boolean enableSessionCreation = true;

    public SSLSocketServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public SSLSocketServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    @Override
    public void setOOBInline(boolean inline) {
        log.warn((Object)"Ignored: sending urgent data is not supported by SSLSockets");
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public void setEnableSessionCreation(boolean enableSessionCreation) {
        this.enableSessionCreation = enableSessionCreation;
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        Object o = this.configuration.get("enabledCipherSuites");
        if (o instanceof String[]) {
            this.setEnabledCipherSuites((String[])o);
        }
        if ((o = this.configuration.get("enabledProtocols")) instanceof String[]) {
            this.setEnabledProtocols((String[])o);
        }
    }

    @Override
    protected ServerSocketFactory getDefaultServerSocketFactory() {
        return SSLServerSocketFactory.getDefault();
    }

    @Override
    protected void configureServerSocket(ServerSocket ss) throws SocketException {
        super.configureServerSocket(ss);
        if (ss instanceof SSLServerSocket) {
            SSLServerSocket sss = (SSLServerSocket)ss;
            if (this.enabledCipherSuites != null) {
                sss.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (this.enabledProtocols != null) {
                sss.setEnabledProtocols(this.enabledProtocols);
            }
            sss.setEnableSessionCreation(this.enableSessionCreation);
        }
    }
}

