/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util.units;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.util.units.BitRateFormatter;
import org.rhq.core.clientapi.util.units.BytesFormatter;
import org.rhq.core.clientapi.util.units.DateFormatter;
import org.rhq.core.clientapi.util.units.DurationFormatter;
import org.rhq.core.clientapi.util.units.FormatSpecifics;
import org.rhq.core.clientapi.util.units.FormattedNumber;
import org.rhq.core.clientapi.util.units.Formatter;
import org.rhq.core.clientapi.util.units.NoFormatter;
import org.rhq.core.clientapi.util.units.PercentageFormatter;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.TemperatureFormatter;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;

public class UnitsFormat {
    private static final HashMap<UnitsConstants, Object> formatters = new HashMap();
    private static Log log;

    public static FormattedNumber format(UnitNumber val) {
        return UnitsFormat.format(val, Locale.getDefault());
    }

    public static FormattedNumber format(UnitNumber val, Locale locale) {
        return UnitsFormat.format(val, locale, null);
    }

    private static Formatter getFormatter(UnitsConstants unitType) {
        Formatter res = (Formatter)formatters.get((Object)unitType);
        if (res == null) {
            throw new IllegalStateException("Unhandled unit type: " + (Object)((Object)unitType));
        }
        return res;
    }

    public static FormattedNumber format(UnitNumber val, Locale locale, FormatSpecifics specifics) {
        Formatter formatter = UnitsFormat.getFormatter(val.getUnits());
        FormattedNumber res = formatter.format(val, locale, specifics);
        if (log.isDebugEnabled()) {
            log.debug((Object)("format(" + val.getValue() + ") -> " + res));
        }
        return res;
    }

    static BigDecimal getBaseValue(double value, UnitsConstants unitType, ScaleConstants scale) {
        return UnitsFormat.getFormatter(unitType).getBaseValue(value, scale);
    }

    static BigDecimal getScaledValue(BigDecimal baseValue, UnitsConstants unitType, ScaleConstants scale) {
        return UnitsFormat.getFormatter(unitType).getScaledValue(baseValue, scale);
    }

    static {
        formatters.put(UnitsConstants.UNIT_NONE, new NoFormatter());
        formatters.put(UnitsConstants.UNIT_BYTES, new BytesFormatter());
        formatters.put(UnitsConstants.UNIT_BITS, new BitRateFormatter());
        formatters.put(UnitsConstants.UNIT_DURATION, new DurationFormatter());
        formatters.put(UnitsConstants.UNIT_DATE, new DateFormatter());
        formatters.put(UnitsConstants.UNIT_PERCENTAGE, new PercentageFormatter());
        formatters.put(UnitsConstants.UNIT_TEMPERATURE, new TemperatureFormatter());
        log = LogFactory.getLog(UnitsFormat.class);
    }
}

