/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.Serializable;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQConnection;
import org.hornetq.jms.referenceable.ConnectionFactoryObjectFactory;
import org.hornetq.jms.referenceable.SerializableObjectRefAddr;

public class HornetQConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
XAConnectionFactory,
XAQueueConnectionFactory,
XATopicConnectionFactory,
Serializable,
Referenceable {
    private static final long serialVersionUID = -2810634789345348326L;
    private static final Logger log = Logger.getLogger(HornetQConnectionFactory.class);
    private final ClientSessionFactory sessionFactory;
    private String clientID;
    private int dupsOKBatchSize = 0x100000;
    private int transactionBatchSize = 0x100000;
    private boolean readOnly;

    public HornetQConnectionFactory() {
        this.sessionFactory = HornetQClient.createClientSessionFactory();
    }

    public HornetQConnectionFactory(ClientSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public HornetQConnectionFactory(String discoveryAddress, int discoveryPort) {
        this.sessionFactory = HornetQClient.createClientSessionFactory((String)discoveryAddress, (int)discoveryPort);
    }

    public HornetQConnectionFactory(List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors) {
        this.sessionFactory = HornetQClient.createClientSessionFactory(staticConnectors);
    }

    public HornetQConnectionFactory(TransportConfiguration connectorConfig, TransportConfiguration backupConnectorConfig) {
        this.sessionFactory = HornetQClient.createClientSessionFactory((TransportConfiguration)connectorConfig, (TransportConfiguration)backupConnectorConfig);
    }

    public HornetQConnectionFactory(TransportConfiguration connectorConfig) {
        this(connectorConfig, null);
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 0);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 1);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 2);
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(null, null);
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, true, 0);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(null, null);
    }

    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, true, 1);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(null, null);
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, true, 2);
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getCanonicalName(), new SerializableObjectRefAddr("HornetQ-CF", this), ConnectionFactoryObjectFactory.class.getCanonicalName(), null);
    }

    public synchronized String getConnectionLoadBalancingPolicyClassName() {
        return this.sessionFactory.getConnectionLoadBalancingPolicyClassName();
    }

    public synchronized void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        this.checkWrite();
        this.sessionFactory.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public synchronized List<Pair<TransportConfiguration, TransportConfiguration>> getStaticConnectors() {
        return this.sessionFactory.getStaticConnectors();
    }

    public synchronized void setStaticConnectors(List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors) {
        this.checkWrite();
        this.sessionFactory.setStaticConnectors(staticConnectors);
    }

    public synchronized String getLocalBindAddress() {
        return this.sessionFactory.getLocalBindAddress();
    }

    public synchronized void setLocalBindAddress(String localBindAddress) {
        this.checkWrite();
        this.sessionFactory.setLocalBindAddress(localBindAddress);
    }

    public synchronized String getDiscoveryAddress() {
        return this.sessionFactory.getDiscoveryAddress();
    }

    public synchronized void setDiscoveryAddress(String discoveryAddress) {
        this.checkWrite();
        this.sessionFactory.setDiscoveryAddress(discoveryAddress);
    }

    public synchronized int getDiscoveryPort() {
        return this.sessionFactory.getDiscoveryPort();
    }

    public synchronized void setDiscoveryPort(int discoveryPort) {
        this.checkWrite();
        this.sessionFactory.setDiscoveryPort(discoveryPort);
    }

    public synchronized long getDiscoveryRefreshTimeout() {
        return this.sessionFactory.getDiscoveryRefreshTimeout();
    }

    public synchronized void setDiscoveryRefreshTimeout(long discoveryRefreshTimeout) {
        this.checkWrite();
        this.sessionFactory.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    public synchronized long getDiscoveryInitialWaitTimeout() {
        return this.sessionFactory.getDiscoveryInitialWaitTimeout();
    }

    public synchronized void setDiscoveryInitialWaitTimeout(long discoveryInitialWaitTimeout) {
        this.checkWrite();
        this.sessionFactory.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    public synchronized String getClientID() {
        return this.clientID;
    }

    public synchronized void setClientID(String clientID) {
        this.checkWrite();
        this.clientID = clientID;
    }

    public synchronized int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    public synchronized void setDupsOKBatchSize(int dupsOKBatchSize) {
        this.checkWrite();
        this.dupsOKBatchSize = dupsOKBatchSize;
    }

    public synchronized int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public synchronized void setTransactionBatchSize(int transactionBatchSize) {
        this.checkWrite();
        this.transactionBatchSize = transactionBatchSize;
    }

    public synchronized long getClientFailureCheckPeriod() {
        return this.sessionFactory.getClientFailureCheckPeriod();
    }

    public synchronized void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.checkWrite();
        this.sessionFactory.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public synchronized long getConnectionTTL() {
        return this.sessionFactory.getConnectionTTL();
    }

    public synchronized void setConnectionTTL(long connectionTTL) {
        this.checkWrite();
        this.sessionFactory.setConnectionTTL(connectionTTL);
    }

    public synchronized long getCallTimeout() {
        return this.sessionFactory.getCallTimeout();
    }

    public synchronized void setCallTimeout(long callTimeout) {
        this.checkWrite();
        this.sessionFactory.setCallTimeout(callTimeout);
    }

    public synchronized int getConsumerWindowSize() {
        return this.sessionFactory.getConsumerWindowSize();
    }

    public synchronized void setConsumerWindowSize(int consumerWindowSize) {
        this.checkWrite();
        this.sessionFactory.setConsumerWindowSize(consumerWindowSize);
    }

    public synchronized int getConsumerMaxRate() {
        return this.sessionFactory.getConsumerMaxRate();
    }

    public synchronized void setConsumerMaxRate(int consumerMaxRate) {
        this.checkWrite();
        this.sessionFactory.setConsumerMaxRate(consumerMaxRate);
    }

    public synchronized int getConfirmationWindowSize() {
        return this.sessionFactory.getConfirmationWindowSize();
    }

    public synchronized void setConfirmationWindowSize(int confirmationWindowSize) {
        this.checkWrite();
        this.sessionFactory.setConfirmationWindowSize(confirmationWindowSize);
    }

    public synchronized int getProducerMaxRate() {
        return this.sessionFactory.getProducerMaxRate();
    }

    public synchronized void setProducerMaxRate(int producerMaxRate) {
        this.checkWrite();
        this.sessionFactory.setProducerMaxRate(producerMaxRate);
    }

    public synchronized int getProducerWindowSize() {
        return this.sessionFactory.getProducerWindowSize();
    }

    public synchronized void setProducerWindowSize(int producerWindowSize) {
        this.checkWrite();
        this.sessionFactory.setProducerWindowSize(producerWindowSize);
    }

    public synchronized void setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.checkWrite();
        this.sessionFactory.setCacheLargeMessagesClient(cacheLargeMessagesClient);
    }

    public synchronized boolean isCacheLargeMessagesClient() {
        return this.sessionFactory.isCacheLargeMessagesClient();
    }

    public synchronized int getMinLargeMessageSize() {
        return this.sessionFactory.getMinLargeMessageSize();
    }

    public synchronized void setMinLargeMessageSize(int minLargeMessageSize) {
        this.checkWrite();
        this.sessionFactory.setMinLargeMessageSize(minLargeMessageSize);
    }

    public synchronized boolean isBlockOnAcknowledge() {
        return this.sessionFactory.isBlockOnAcknowledge();
    }

    public synchronized void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.checkWrite();
        this.sessionFactory.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public synchronized boolean isBlockOnNonDurableSend() {
        return this.sessionFactory.isBlockOnNonDurableSend();
    }

    public synchronized void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.checkWrite();
        this.sessionFactory.setBlockOnNonDurableSend(blockOnNonDurableSend);
    }

    public synchronized boolean isBlockOnDurableSend() {
        return this.sessionFactory.isBlockOnDurableSend();
    }

    public synchronized void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.checkWrite();
        this.sessionFactory.setBlockOnDurableSend(blockOnDurableSend);
    }

    public synchronized boolean isAutoGroup() {
        return this.sessionFactory.isAutoGroup();
    }

    public synchronized void setAutoGroup(boolean autoGroup) {
        this.checkWrite();
        this.sessionFactory.setAutoGroup(autoGroup);
    }

    public synchronized boolean isPreAcknowledge() {
        return this.sessionFactory.isPreAcknowledge();
    }

    public synchronized void setPreAcknowledge(boolean preAcknowledge) {
        this.checkWrite();
        this.sessionFactory.setPreAcknowledge(preAcknowledge);
    }

    public synchronized long getRetryInterval() {
        return this.sessionFactory.getRetryInterval();
    }

    public synchronized void setRetryInterval(long retryInterval) {
        this.checkWrite();
        this.sessionFactory.setRetryInterval(retryInterval);
    }

    public synchronized long getMaxRetryInterval() {
        return this.sessionFactory.getMaxRetryInterval();
    }

    public synchronized void setMaxRetryInterval(long retryInterval) {
        this.checkWrite();
        this.sessionFactory.setMaxRetryInterval(retryInterval);
    }

    public synchronized double getRetryIntervalMultiplier() {
        return this.sessionFactory.getRetryIntervalMultiplier();
    }

    public synchronized void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.checkWrite();
        this.sessionFactory.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public synchronized int getReconnectAttempts() {
        return this.sessionFactory.getReconnectAttempts();
    }

    public synchronized void setReconnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.sessionFactory.setReconnectAttempts(reconnectAttempts);
    }

    public synchronized boolean isFailoverOnInitialConnection() {
        return this.sessionFactory.isFailoverOnInitialConnection();
    }

    public synchronized void setFailoverOnInitialConnection(boolean failover) {
        this.checkWrite();
        this.sessionFactory.setFailoverOnInitialConnection(failover);
    }

    public synchronized boolean isFailoverOnServerShutdown() {
        return this.sessionFactory.isFailoverOnServerShutdown();
    }

    public synchronized void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.checkWrite();
        this.sessionFactory.setFailoverOnServerShutdown(failoverOnServerShutdown);
    }

    public synchronized boolean isUseGlobalPools() {
        return this.sessionFactory.isUseGlobalPools();
    }

    public synchronized void setUseGlobalPools(boolean useGlobalPools) {
        this.checkWrite();
        this.sessionFactory.setUseGlobalPools(useGlobalPools);
    }

    public synchronized int getScheduledThreadPoolMaxSize() {
        return this.sessionFactory.getScheduledThreadPoolMaxSize();
    }

    public synchronized void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.checkWrite();
        this.sessionFactory.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public synchronized int getThreadPoolMaxSize() {
        return this.sessionFactory.getThreadPoolMaxSize();
    }

    public synchronized void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.checkWrite();
        this.sessionFactory.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public synchronized int getInitialMessagePacketSize() {
        return this.sessionFactory.getInitialMessagePacketSize();
    }

    public synchronized void setInitialMessagePacketSize(int size) {
        this.checkWrite();
        this.sessionFactory.setInitialMessagePacketSize(size);
    }

    public ClientSessionFactory getCoreFactory() {
        return this.sessionFactory;
    }

    public void setGroupID(String groupID) {
        this.sessionFactory.setGroupID(groupID);
    }

    public String getGroupID() {
        return this.sessionFactory.getGroupID();
    }

    public void close() {
        this.sessionFactory.close();
    }

    protected synchronized HornetQConnection createConnectionInternal(String username, String password, boolean isXA, int type) throws JMSException {
        this.readOnly = true;
        ClientSessionFactory factory = this.sessionFactory.copy();
        HornetQConnection connection = new HornetQConnection(username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, factory);
        try {
            connection.authorize();
        }
        catch (JMSException e) {
            try {
                connection.close();
            }
            catch (JMSException me) {
                // empty catch block
            }
            throw e;
        }
        return connection;
    }

    private void checkWrite() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set attribute on HornetQConnectionFactory after it has been used");
        }
    }
}

