/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jndi.binder.impl;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.ejb3.jndi.binder.spi.ProxyFactory;

public abstract class AbstractLazyProxyFactory
implements ProxyFactory {
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method m) {
            return !"finalize".equals(m.getName()) || m.getParameterTypes().length != 0;
        }
    };

    public Object lazyLinkRef(String className, String linkName) {
        String factory = LazyObjectFactory.class.getName();
        StringRefAddr addr = new StringRefAddr("link", linkName);
        return new Reference(className, addr, factory, null);
    }

    protected static Class<?> getProxyClass(javassist.util.proxy.ProxyFactory factory) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return factory.createClass();
        }
        return (Class)AccessController.doPrivileged(new ClassCreator(factory));
    }

    protected static class ClassCreator
    implements PrivilegedAction<Class<?>> {
        private javassist.util.proxy.ProxyFactory factory;

        public ClassCreator(javassist.util.proxy.ProxyFactory factory) {
            this.factory = factory;
        }

        @Override
        public Class<?> run() {
            return this.factory.createClass();
        }
    }

    public static class LazyHandler
    implements MethodHandler {
        private static final Method METHOD_EQUALS;
        private static final Method METHOD_HASH_CODE;
        private static final Method METHOD_TO_STRING;
        private String link;
        private Context context;
        private Object target;

        public LazyHandler(String link, Context context) {
            this.link = link;
            this.context = context;
        }

        public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
            if (method.equals(METHOD_TO_STRING)) {
                return "JNDI-link: " + this.link;
            }
            if (method.equals(METHOD_EQUALS)) {
                return this.equals(args[0]);
            }
            if (method.equals(METHOD_HASH_CODE)) {
                return this.hashCode();
            }
            if (this.target == null) {
                this.target = this.context.lookup(this.link);
            }
            return method.invoke(this.target, args);
        }

        static {
            try {
                METHOD_EQUALS = Object.class.getDeclaredMethod("equals", Object.class);
                METHOD_HASH_CODE = Object.class.getDeclaredMethod("hashCode", new Class[0]);
                METHOD_TO_STRING = Object.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class LazyObjectFactory
    implements ObjectFactory {
        @Override
        public Object getObjectInstance(Object obj, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
            if (obj == null || !(obj instanceof Reference)) {
                return null;
            }
            Reference ref = (Reference)obj;
            RefAddr addr = ref.get("link");
            if (addr == null || !(addr instanceof StringRefAddr)) {
                return null;
            }
            String link = (String)addr.getContent();
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = tccl.loadClass(ref.getClassName());
            javassist.util.proxy.ProxyFactory factory = new javassist.util.proxy.ProxyFactory();
            factory.setFilter(FINALIZE_FILTER);
            if (clazz.isInterface()) {
                factory.setInterfaces(new Class[]{clazz});
            } else {
                factory.setSuperclass(clazz);
            }
            Class<?> proxyClass = AbstractLazyProxyFactory.getProxyClass(factory);
            ProxyObject proxy = (ProxyObject)proxyClass.newInstance();
            proxy.setHandler((MethodHandler)new LazyHandler(link, context));
            return proxy;
        }
    }
}

