/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client;

import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb3.BeanContext;
import org.jboss.injection.AbstractPropertyInjector;
import org.jboss.injection.PojoInjector;
import org.jboss.injection.lang.reflect.BeanProperty;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiPropertyInjector
extends AbstractPropertyInjector
implements PojoInjector {
    private static final Logger log = Logger.getLogger(JndiPropertyInjector.class);
    private String jndiName;
    private Context ctx;

    public JndiPropertyInjector(BeanProperty property, String jndiName, Context ctx) {
        super(property);
        this.jndiName = jndiName;
        this.ctx = ctx;
    }

    public void inject(BeanContext bctx) {
    }

    public Class<?> getInjectionClass() {
        return this.property.getType();
    }

    public void inject(BeanContext bctx, Object instance) {
    }

    public void inject(Object instance) {
        Object value = this.lookup(this.jndiName);
        log.trace((Object)("injecting " + value + " from " + this.jndiName + " into " + this.property + " of " + instance));
        try {
            this.property.set(instance, value);
        }
        catch (IllegalArgumentException e) {
            Class<?> c1 = value.getClass();
            StringBuffer buffer = new StringBuffer("Jndi value '" + this.jndiName + "' class info:");
            JndiPropertyInjector.displayClassInfo(c1, buffer);
            log.debug((Object)("Failed to inject jndi property, " + buffer));
            Class c2 = this.property.getType();
            buffer.setLength(0);
            buffer.append("Field " + this.property.getName() + " class info:");
            JndiPropertyInjector.displayClassInfo(c2, buffer);
            log.debug((Object)(", " + buffer));
            throw e;
        }
    }

    protected Object lookup(String jndiName) {
        Object dependency;
        block11: {
            dependency = null;
            boolean trace = log.isTraceEnabled();
            try {
                if (trace) {
                    log.trace((Object)("Looking for enc entry: " + jndiName));
                }
                dependency = this.ctx.lookup(jndiName);
                if (trace) {
                    log.trace((Object)("Success: " + dependency));
                }
            }
            catch (NamingException e) {
                block10: {
                    if (trace) {
                        log.trace((Object)("Failed enc lookup: " + e.getExplanation()));
                    }
                    try {
                        if (trace) {
                            log.trace((Object)("Failed trying as global entry: " + jndiName));
                        }
                        InitialContext ictx = new InitialContext(this.ctx.getEnvironment());
                        dependency = ictx.lookup(jndiName);
                        if (trace) {
                            log.trace((Object)("Success: " + dependency));
                        }
                    }
                    catch (NamingException e2) {
                        if (!trace) break block10;
                        log.trace((Object)("Failed global lookup: " + e2.getExplanation()));
                    }
                }
                if (dependency != null) break block11;
                Throwable cause = e;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                throw new RuntimeException("Unable to inject jndi dependency: " + jndiName + " into property " + this.property + ": " + cause.getMessage(), e);
            }
        }
        return dependency;
    }

    static void displayClassInfo(Class clazz, StringBuffer results) {
        ClassLoader cl = clazz.getClassLoader();
        results.append("\n" + clazz.getName() + ".ClassLoader=" + cl);
        CodeSource clazzCS = clazz.getProtectionDomain().getCodeSource();
        if (clazzCS != null) {
            results.append("\n++++CodeSource: " + clazzCS);
        } else {
            results.append("\n++++Null CodeSource");
        }
        results.append("\nImplemented Interfaces:");
        Class<?>[] ifaces = clazz.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            results.append("\n++" + ifaces[i]);
            ClassLoader loader = ifaces[i].getClassLoader();
            results.append("\n++++ClassLoader: " + loader);
            ProtectionDomain pd = ifaces[i].getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                results.append("\n++++CodeSource: " + cs);
                continue;
            }
            results.append("\n++++Null CodeSource");
        }
    }
}

