/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.logging.Logger;
import org.jboss.net.sockets.DefaultClientSocketFactory;
import org.jboss.net.sockets.DefaultSocketFactory;
import org.jboss.system.server.jmx.JMXAdapter;
import org.jboss.system.server.jmx.JMXConnectorAuthenticator;
import org.jboss.system.server.jmx.MBeanServerWrapper;
import org.jboss.util.naming.Util;
import org.picketbox.factories.SecurityFactory;

public class JMXConnector {
    private int rmiRegistryPort = 1090;
    private int rmiServerPort = 1091;
    private String hostname = "localhost";
    private static final String RMI_BIND_NAME = "jmxrmi";
    private static final String LEGACY_RMI_BIND_NAME = "jmxconnector";
    private static final String JNDI_BIND_NAME = "jmx/invoker/RMIAdaptor";
    private static final String LEGACY_BIND_NAME = "jmx/rmi/RMIAdaptor";
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private InitialContext context;
    private String securityDomain;
    private RMIConnectorServer adapter;
    private RMIJRMPServerImpl rmiServer;
    private Registry registry;
    private static final Logger log = Logger.getLogger(JMXConnector.class);

    public InitialContext getContext() {
        return this.context;
    }

    public void setContext(InitialContext context) {
        this.context = context;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public int getRmiRegistryPort() {
        return this.rmiRegistryPort;
    }

    public void setRmiRegistryPort(int rmiRegistryPort) {
        this.rmiRegistryPort = rmiRegistryPort;
    }

    public int getRmiServerPort() {
        return this.rmiServerPort;
    }

    public void setRmiServerPort(int rmiServerPort) {
        this.rmiServerPort = rmiServerPort;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void start() {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("starting JMXConnector on host " + this.hostname + ":" + this.rmiRegistryPort));
            }
            DefaultClientSocketFactory clientSocketFactory = new DefaultClientSocketFactory();
            clientSocketFactory.setBindAddress(this.hostname);
            DefaultSocketFactory serverSocketFactory = new DefaultSocketFactory();
            serverSocketFactory.setBindAddress(this.hostname);
            this.registry = LocateRegistry.createRegistry(this.rmiRegistryPort, (RMIClientSocketFactory)clientSocketFactory, (RMIServerSocketFactory)serverSocketFactory);
            HashMap<String, JMXConnectorAuthenticator> env = new HashMap<String, JMXConnectorAuthenticator>();
            if (this.securityDomain != null) {
                env.put("jmx.remote.authenticator", new JMXConnectorAuthenticator(this.securityDomain));
            }
            this.rmiServer = new RMIJRMPServerImpl(this.rmiServerPort, null, (RMIServerSocketFactory)serverSocketFactory, env);
            JMXServiceURL url = this.buildJMXServiceURL();
            this.adapter = new RMIConnectorServer(url, env, this.rmiServer, this.wrapMBeanServer(this.mbeanServer));
            this.adapter.start();
            url = this.adapter.getAddress();
            this.registry.rebind(RMI_BIND_NAME, this.rmiServer.toStub());
            this.registry.rebind(LEGACY_RMI_BIND_NAME, this.rmiServer.toStub());
            if (log.isDebugEnabled()) {
                log.debug((Object)("started JMXConnector (" + url.toString() + ")" + (this.securityDomain != null ? " domain=" + this.securityDomain : "")));
            }
            Reference reference = new Reference(MBeanServerConnection.class.getName(), JMXAdapter.class.getName(), null);
            reference.add(new StringRefAddr("JMXServiceURL", url.toString()));
            Util.rebind((Context)this.context, (String)JNDI_BIND_NAME, (Object)reference);
            Util.rebind((Context)this.context, (String)LEGACY_BIND_NAME, (Object)reference);
            SecurityFactory.prepare();
        }
        catch (IOException e) {
            log.error((Object)"Could not start JMXConnector", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"couldn't bind legacy adaptor (jmx/invoker/RMIAdaptor or jmx/rmi/RMIAdaptor)", (Throwable)e);
        }
    }

    private JMXServiceURL buildJMXServiceURL() throws MalformedURLException {
        String host = this.hostname;
        if (host.indexOf(58) != -1) {
            host = "[" + host + "]";
        }
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + host);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.registry.unbind(RMI_BIND_NAME);
            this.registry.unbind(LEGACY_RMI_BIND_NAME);
            Util.unbind((Context)this.context, (String)JNDI_BIND_NAME);
            Util.unbind((Context)this.context, (String)LEGACY_BIND_NAME);
            UnicastRemoteObject.unexportObject(this.registry, true);
            log.info((Object)(this.getClass().getSimpleName() + " stopped"));
        }
        catch (NotBoundException e) {
            log.error((Object)"connector was not bound (jmxrmi or jmxconnector) to registry", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"couldn't unbind (jmxrmi or jmxconnector) connector", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"couldn't unbind legacy adaptor (jmx/invoker/RMIAdaptor or jmx/rmi/RMIAdaptor)", (Throwable)e);
        }
        finally {
            try {
                SecurityFactory.release();
                this.adapter.stop();
            }
            catch (IOException e) {
                log.error((Object)"Could not stop connector", (Throwable)e);
            }
        }
    }

    private MBeanServer wrapMBeanServer(MBeanServer mbServer) {
        return new MBeanServerWrapper(mbServer);
    }
}

