/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.clustered.local.AbstractLocalContentManager;
import org.jboss.system.server.profileservice.repository.clustered.local.ContentMetadataPersister;
import org.jboss.system.server.profileservice.repository.clustered.local.file.AddContentStreamAction;
import org.jboss.system.server.profileservice.repository.clustered.local.file.DirectoryTimestampUpdateAction;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileBasedSynchronizationActionContext;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileReadAction;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileUtil;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileWriteAction;
import org.jboss.system.server.profileservice.repository.clustered.local.file.InitiateRmdirAction;
import org.jboss.system.server.profileservice.repository.clustered.local.file.MkDirAction;
import org.jboss.system.server.profileservice.repository.clustered.local.file.RemoveFileAction;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;
import org.jboss.system.server.profileservice.repository.clustered.sync.NoOpSynchronizationAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.RemoteRemovalAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.SimpleSynchronizationRemoteAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationId;
import org.jboss.system.server.profileservice.repository.clustered.sync.TwoPhaseCommitAction;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemLocalContentManager
extends AbstractLocalContentManager<FileBasedSynchronizationActionContext> {
    private final File tmpDir;

    protected FilesystemLocalContentManager(Map<String, URI> namedURIMap, ProfileKey profileKey, String localNodeName, ContentMetadataPersister contentMetadataPersister, URI tempDirURI) {
        super(namedURIMap, profileKey, localNodeName, contentMetadataPersister);
        this.tmpDir = tempDirURI != null ? new File(tempDirURI) : null;
    }

    @Override
    protected Closeable mountRepositoryRoot(URI realURI, VirtualFile backup) {
        try {
            File realFile = new File(realURI);
            return VFS.mountReal((File)realFile, (VirtualFile)backup);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to mount file with URI " + realURI, e);
        }
    }

    @Override
    protected FileBasedSynchronizationActionContext createSynchronizationActionContext(SynchronizationId<?> id, RepositoryContentMetadata toUpdate) {
        return new FileBasedSynchronizationActionContext(id, toUpdate, this.tmpDir, this.getStoreName());
    }

    @Override
    protected TwoPhaseCommitAction<FileBasedSynchronizationActionContext> createPullFromClusterAction(ContentModification mod, boolean localLed) {
        File targetFile = FileUtil.getFileForItem(this.getRootVirtualFileForModification(mod), mod.getItem());
        if (localLed) {
            return new FileWriteAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
        }
        return new FileReadAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
    }

    @Override
    protected TwoPhaseCommitAction<FileBasedSynchronizationActionContext> createPushToClusterAction(ContentModification mod, boolean localLed) {
        File targetFile = FileUtil.getFileForItem(this.getRootVirtualFileForModification(mod), mod.getItem());
        if (localLed) {
            return new FileReadAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
        }
        return new FileWriteAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
    }

    @Override
    protected TwoPhaseCommitAction<FileBasedSynchronizationActionContext> createPushStreamToClusterAction(ContentModification mod, InputStream stream) {
        File targetFile = FileUtil.getFileForItem(this.getRootVirtualFileForModification(mod), mod.getItem());
        return new AddContentStreamAction(stream, targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
    }

    @Override
    protected TwoPhaseCommitAction<FileBasedSynchronizationActionContext> createRemoveFromClusterAction(ContentModification mod, boolean localLed) {
        if (localLed) {
            File targetFile = FileUtil.getFileForItem(this.getRootVirtualFileForModification(mod), mod.getItem());
            return new RemoveFileAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
        }
        return new NoOpSynchronizationAction<FileBasedSynchronizationActionContext>((FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
    }

    @Override
    protected TwoPhaseCommitAction<FileBasedSynchronizationActionContext> createRemoveToClusterAction(ContentModification mod, boolean localLed) {
        if (localLed) {
            return new RemoteRemovalAction<FileBasedSynchronizationActionContext>((FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
        }
        File targetFile = FileUtil.getFileForItem(this.getRootVirtualFileForModification(mod), mod.getItem());
        return new RemoveFileAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
    }

    @Override
    protected TwoPhaseCommitAction<FileBasedSynchronizationActionContext> createDirectoryTimestampMismatchAction(ContentModification mod, boolean localLed) {
        if (localLed) {
            File targetFile = FileUtil.getFileForItem(this.getRootVirtualFileForModification(mod), mod.getItem());
            return new DirectoryTimestampUpdateAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
        }
        return new NoOpSynchronizationAction<FileBasedSynchronizationActionContext>((FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
    }

    @Override
    protected TwoPhaseCommitAction<FileBasedSynchronizationActionContext> createMkdirFromClusterAction(ContentModification mod, boolean localLed) {
        if (localLed) {
            File targetFile = FileUtil.getFileForItem(this.getRootVirtualFileForModification(mod), mod.getItem());
            return new MkDirAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
        }
        return new NoOpSynchronizationAction<FileBasedSynchronizationActionContext>((FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
    }

    @Override
    protected TwoPhaseCommitAction<FileBasedSynchronizationActionContext> createMkdirToClusterAction(ContentModification mod, boolean localLed) {
        if (localLed) {
            return new SimpleSynchronizationRemoteAction<FileBasedSynchronizationActionContext>((FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
        }
        File targetFile = FileUtil.getFileForItem(this.getRootVirtualFileForModification(mod), mod.getItem());
        return new MkDirAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
    }

    @Override
    protected TwoPhaseCommitAction<FileBasedSynchronizationActionContext> createPrepareRmdirFromClusterAction(ContentModification mod, boolean localLed) {
        if (localLed) {
            File targetFile = FileUtil.getFileForItem(this.getRootVirtualFileForModification(mod), mod.getItem());
            return new InitiateRmdirAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
        }
        return new NoOpSynchronizationAction<FileBasedSynchronizationActionContext>((FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
    }

    @Override
    protected TwoPhaseCommitAction<FileBasedSynchronizationActionContext> createPrepareRmdirToClusterAction(ContentModification mod, boolean localLed) {
        if (localLed) {
            boolean initiation = true;
            return new SimpleSynchronizationRemoteAction<FileBasedSynchronizationActionContext>((FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod, initiation);
        }
        File targetFile = FileUtil.getFileForItem(this.getRootVirtualFileForModification(mod), mod.getItem());
        return new InitiateRmdirAction(targetFile, (FileBasedSynchronizationActionContext)this.getSynchronizationActionContext(), mod);
    }
}

