/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.compression;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.compression.ZlibUtil;
import org.jboss.netty.handler.codec.compression.ZlibWrapper;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.jboss.netty.util.internal.jzlib.JZlib;
import org.jboss.netty.util.internal.jzlib.ZStream;

public class ZlibDecoder
extends OneToOneDecoder {
    private final ZStream z = new ZStream();
    private volatile boolean finished;

    public ZlibDecoder() {
        this(ZlibWrapper.ZLIB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZlibDecoder(ZlibWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException("wrapper");
        }
        ZStream zStream = this.z;
        synchronized (zStream) {
            int resultCode = this.z.inflateInit(ZlibUtil.convertWrapperType(wrapper));
            if (resultCode != 0) {
                ZlibUtil.fail(this.z, "initialization failure", resultCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZlibDecoder(byte[] dictionary) {
        if (dictionary == null) {
            throw new NullPointerException("dictionary");
        }
        ZStream zStream = this.z;
        synchronized (zStream) {
            int resultCode = this.z.inflateInit(JZlib.W_ZLIB);
            if (resultCode != 0) {
                ZlibUtil.fail(this.z, "initialization failure", resultCode);
            } else {
                resultCode = this.z.inflateSetDictionary(dictionary, dictionary.length);
                if (resultCode != 0) {
                    ZlibUtil.fail(this.z, "failed to set the dictionary", resultCode);
                }
            }
        }
    }

    public boolean isClosed() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer) || this.finished) {
            return msg;
        }
        ZStream zStream = this.z;
        synchronized (zStream) {
            block11: {
                ChannelBuffer channelBuffer;
                try {
                    ChannelBuffer compressed = (ChannelBuffer)msg;
                    byte[] in = new byte[compressed.readableBytes()];
                    compressed.readBytes(in);
                    this.z.next_in = in;
                    this.z.next_in_index = 0;
                    this.z.avail_in = in.length;
                    byte[] out = new byte[in.length << 1];
                    ChannelBuffer decompressed = ChannelBuffers.dynamicBuffer(compressed.order(), out.length, ctx.getChannel().getConfig().getBufferFactory());
                    this.z.next_out = out;
                    this.z.next_out_index = 0;
                    this.z.avail_out = out.length;
                    block9: do {
                        int resultCode = this.z.inflate(2);
                        switch (resultCode) {
                            case -5: 
                            case 0: 
                            case 1: {
                                decompressed.writeBytes(out, 0, this.z.next_out_index);
                                this.z.next_out_index = 0;
                                this.z.avail_out = out.length;
                                if (resultCode != 1) continue block9;
                                this.finished = true;
                                this.z.inflateEnd();
                                break;
                            }
                            default: {
                                ZlibUtil.fail(this.z, "decompression failure", resultCode);
                            }
                        }
                    } while (this.z.avail_in > 0);
                    if (decompressed.writerIndex() == 0) break block11;
                    channelBuffer = decompressed;
                    {
                        Object var11_12 = null;
                        this.z.next_in = null;
                        this.z.next_out = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    this.z.next_in = null;
                    this.z.next_out = null;
                    throw throwable;
                }
                return channelBuffer;
            }
            Object var9_11 = null;
            {
                Object var11_13 = null;
                this.z.next_in = null;
                this.z.next_out = null;
            }
            return var9_11;
        }
    }
}

