/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.plugins;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtils {
    public static final void checkClassName(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new ClassNotFoundException("Null class name");
        }
        if (className.trim().length() == 0) {
            throw new ClassNotFoundException("Empty class name '" + className + "'");
        }
    }

    public static final String classNameToPath(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Null className");
        }
        return className.replace('.', '/') + ".class";
    }

    public static final String classNameToPath(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        return ClassLoaderUtils.classNameToPath(clazz.getName());
    }

    public static final String resourceNameToClassName(String resourceName) {
        if (!resourceName.endsWith(".class")) {
            return null;
        }
        resourceName = resourceName.substring(0, resourceName.length() - 6);
        return resourceName.replace('/', '.');
    }

    public static final String packageNameToPath(String className) {
        String packageName = ClassLoaderUtils.getClassPackageName(className);
        return packageName.replace('.', '/');
    }

    public static final String packageToPath(String packageName) {
        return packageName.replace('.', '/');
    }

    public static final String pathToPackage(String pathName) {
        return pathName.replace('/', '.');
    }

    public static final String getClassPackageName(String className) {
        int end = className.lastIndexOf(46);
        if (end == -1) {
            return "";
        }
        return className.substring(0, end);
    }

    public static final String getResourcePackageName(String className) {
        int i = className.lastIndexOf(47);
        if (i == -1) {
            return "";
        }
        return className.substring(0, i).replace('/', '.');
    }

    public static final byte[] loadByteCode(String name, InputStream is) {
        try {
            byte[] byArray = ClassLoaderUtils.readBytes(is);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load class byte code " + name, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadBytes(InputStream is) throws IOException {
        try {
            byte[] byArray = ClassLoaderUtils.readBytes(is);
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static final byte[] readBytes(InputStream is) throws IOException {
        int read;
        if (is == null) {
            throw new IllegalArgumentException("Null input stream.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] tmp = new byte[1024];
        while ((read = is.read(tmp)) >= 0) {
            baos.write(tmp, 0, read);
        }
        return baos.toByteArray();
    }

    public static final String classToString(Class<?> clazz) {
        if (clazz == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        ClassLoaderUtils.classToString(clazz, builder);
        return builder.toString();
    }

    public static final void classToString(Class<?> clazz, StringBuilder builder) {
        if (clazz == null) {
            builder.append("null");
            return;
        }
        builder.append(clazz);
        builder.append('{');
        ClassLoader cl = ClassLoaderUtils.getClassLoader(clazz);
        builder.append("cl=").append(cl);
        builder.append(" codeSource=");
        builder.append(ClassLoaderUtils.getCodeSource(clazz));
        builder.append("}");
    }

    private static final ClassLoader getClassLoader(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    private static final ProtectionDomain getProtectionDomain(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return clazz.getProtectionDomain();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz.getProtectionDomain();
            }
        });
    }

    private static final CodeSource getCodeSource(Class<?> clazz) {
        ProtectionDomain protectionDomain = ClassLoaderUtils.getProtectionDomain(clazz);
        if (protectionDomain == null) {
            return null;
        }
        return protectionDomain.getCodeSource();
    }

    public static int compareURL(URL one, URL two) {
        int d;
        String b;
        if (one == null) {
            throw new IllegalArgumentException("Null one");
        }
        if (two == null) {
            throw new IllegalArgumentException("Null one");
        }
        String a = one.getProtocol();
        int result = ClassLoaderUtils.compare(a, b = two.getProtocol());
        if (result != 0) {
            return result;
        }
        a = one.getHost();
        result = ClassLoaderUtils.compare(a, b = two.getHost());
        if (result != 0) {
            return result;
        }
        a = one.getFile();
        result = ClassLoaderUtils.compare(a, b = two.getFile());
        if (result != 0) {
            return result;
        }
        int c = one.getPort();
        result = c - (d = two.getPort());
        if (result != 0) {
            return result;
        }
        String ref1 = one.getRef();
        String ref2 = two.getRef();
        return ClassLoaderUtils.compare(ref1, ref2);
    }

    private static int compare(String one, String two) {
        if (one == null && two == null) {
            return 0;
        }
        if (one == null) {
            return -1;
        }
        if (two == null) {
            return 1;
        }
        return one.compareTo(two);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URLComparator
    implements Comparator<URL>,
    Serializable {
        private static final long serialVersionUID = 169805004616968144L;
        public static final URLComparator INSTANCE = new URLComparator();

        @Override
        public int compare(URL o1, URL o2) {
            return ClassLoaderUtils.compareURL(o1, o2);
        }
    }
}

