/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.ImportType;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseDelegateLoader;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.helpers.AbstractClassLoaderCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderInformation
extends AbstractClassLoaderCache {
    private BaseClassLoader classLoader;
    private BaseClassLoaderPolicy policy;
    private int order;
    private BaseDelegateLoader exported;
    private volatile Map<ImportType, List<DelegateLoader>> delegates;
    private int cantCache;
    private int cantBlacklist;
    private Map<ImportType, Map<String, List<Loader>>> index;

    public ClassLoaderInformation(BaseClassLoader classLoader, BaseClassLoaderPolicy policy, int order) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        if (policy == null) {
            throw new IllegalArgumentException("Null policy");
        }
        this.classLoader = classLoader;
        this.policy = policy;
        this.order = order;
        this.exported = policy.getExported();
        boolean canCache = policy.isCacheable();
        boolean canBlackList = policy.isBlackListable();
        this.index = new ConcurrentHashMap<ImportType, Map<String, List<Loader>>>();
        List<? extends DelegateLoader> delegates = policy.getDelegates();
        if (delegates != null && !delegates.isEmpty()) {
            HashMap temp = new HashMap();
            CopyOnWriteArrayList<DelegateLoader> all = new CopyOnWriteArrayList<DelegateLoader>();
            temp.put(ImportType.ALL, all);
            for (DelegateLoader delegateLoader : delegates) {
                if (delegateLoader == null) {
                    throw new IllegalStateException(policy + " null delegate in " + delegates);
                }
                ImportType importType = delegateLoader.getImportType();
                CopyOnWriteArrayList<DelegateLoader> loaders = (CopyOnWriteArrayList<DelegateLoader>)temp.get((Object)importType);
                if (loaders == null) {
                    loaders = new CopyOnWriteArrayList<DelegateLoader>();
                    temp.put(importType, loaders);
                }
                loaders.add(delegateLoader);
                all.add(delegateLoader);
                DelegateLoader baseDelegate = delegateLoader;
                BaseClassLoaderPolicy delegatePolicy = ((BaseDelegateLoader)baseDelegate).getPolicy();
                if (delegatePolicy == null || !delegatePolicy.isCacheable()) {
                    canCache = false;
                    ++this.cantCache;
                }
                if (delegatePolicy == null || !delegatePolicy.isBlackListable()) {
                    canBlackList = false;
                    ++this.cantBlacklist;
                }
                this.addLoaderToIndex(delegateLoader, importType, ImportType.ALL);
            }
            this.delegates = Collections.synchronizedMap(temp);
        }
        if (canCache) {
            this.restoreCache();
        }
        if (canBlackList) {
            this.restoreBlackList();
        }
    }

    public BaseClassLoader getClassLoader() {
        return this.classLoader;
    }

    public BaseClassLoaderPolicy getPolicy() {
        return this.policy;
    }

    public int getOrder() {
        return this.order;
    }

    public BaseDelegateLoader getExported() {
        return this.exported;
    }

    @Deprecated
    public List<? extends DelegateLoader> getDelegates() {
        return this.getDelegates(ImportType.BEFORE);
    }

    public List<? extends DelegateLoader> getDelegates(ImportType type) {
        if (this.delegates == null) {
            return Collections.emptyList();
        }
        return this.delegates.get((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDelegate(DelegateLoader loader) {
        DelegateLoader baseDelegate;
        BaseClassLoaderPolicy policy;
        if (loader == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        if (this.delegates == null) {
            this.delegates = Collections.synchronizedMap(new HashMap());
        }
        boolean canCache = (policy = ((BaseDelegateLoader)(baseDelegate = loader)).getPolicy()) != null && policy.isCacheable();
        boolean canBlackList = policy != null && policy.isBlackListable();
        ImportType type = loader.getImportType();
        Map<ImportType, List<DelegateLoader>> map = this.delegates;
        synchronized (map) {
            List<DelegateLoader> list = this.delegates.get((Object)type);
            if (list == null) {
                list = new CopyOnWriteArrayList<DelegateLoader>();
                this.delegates.put(type, list);
            }
            list.add(0, loader);
            List<DelegateLoader> all = this.delegates.get((Object)ImportType.ALL);
            if (all == null) {
                all = new CopyOnWriteArrayList<DelegateLoader>();
                this.delegates.put(ImportType.ALL, all);
            }
            all.add(loader);
            if (!canCache) {
                if (this.cantCache == 0) {
                    this.destroyCache();
                }
                ++this.cantCache;
            }
            if (!canBlackList) {
                if (this.cantBlacklist == 0) {
                    this.destroyBlackList();
                }
                ++this.cantBlacklist;
            }
            this.addLoaderToIndex(loader, type, ImportType.ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDelegate(DelegateLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        if (this.delegates == null) {
            return;
        }
        DelegateLoader baseDelegate = loader;
        BaseClassLoaderPolicy policy = ((BaseDelegateLoader)baseDelegate).getPolicy();
        boolean canCache = policy != null && policy.isCacheable();
        boolean canBlackList = policy != null && policy.isBlackListable();
        ImportType type = loader.getImportType();
        Map<ImportType, List<DelegateLoader>> map = this.delegates;
        synchronized (map) {
            List<DelegateLoader> list = this.delegates.get((Object)type);
            if (list != null && list.remove(loader) && list.isEmpty()) {
                this.delegates.remove((Object)type);
            }
            boolean member = false;
            List<DelegateLoader> all = this.delegates.get((Object)ImportType.ALL);
            if (all != null && (member = all.remove(loader)) && all.isEmpty()) {
                this.delegates.remove((Object)ImportType.ALL);
            }
            if (member) {
                if (!canCache) {
                    --this.cantCache;
                    if (this.cantCache == 0) {
                        this.restoreCache();
                    }
                }
                if (!canBlackList) {
                    --this.cantBlacklist;
                    if (this.cantBlacklist == 0) {
                        this.restoreBlackList();
                    }
                }
                this.removeLoaderFromIndex(loader, type, ImportType.ALL);
            }
        }
    }

    Set<String> getImportedPackages() {
        Map<String, List<Loader>> map = this.index.get((Object)ImportType.ALL);
        return map != null ? map.keySet() : Collections.emptySet();
    }

    private void addLoaderToIndex(DelegateLoader loader, ImportType ... types) {
        String[] packageNames = loader.getPackageNames();
        if (packageNames != null && packageNames.length > 0) {
            ClassFilter filter = loader.getFilter();
            for (ImportType type : types) {
                Map<String, List<Loader>> map = this.index.get((Object)type);
                if (map == null) {
                    map = new ConcurrentHashMap<String, List<Loader>>();
                    this.index.put(type, map);
                }
                for (String pn : packageNames) {
                    if (filter == null || !filter.matchesPackageName(pn)) continue;
                    List<Loader> loaders = map.get(pn);
                    if (loaders == null) {
                        loaders = new CopyOnWriteArrayList<Loader>();
                        map.put(pn, loaders);
                    }
                    loaders.add(loader);
                }
            }
        }
    }

    private void removeLoaderFromIndex(DelegateLoader loader, ImportType ... types) {
        String[] packageNames = loader.getPackageNames();
        if (packageNames != null && packageNames.length > 0) {
            ClassFilter filter = loader.getFilter();
            for (ImportType type : types) {
                Map<String, List<Loader>> map = this.index.get((Object)type);
                if (map == null) continue;
                for (String pn : packageNames) {
                    List<Loader> loaders;
                    if (filter == null || !filter.matchesPackageName(pn) || (loaders = map.get(pn)) == null || !loaders.remove(loader) || !loaders.isEmpty()) continue;
                    map.remove(pn);
                    if (!map.isEmpty()) continue;
                    this.index.remove((Object)type);
                }
            }
        }
    }

    @Override
    public boolean isRelevant(ImportType type) {
        List<? extends DelegateLoader> loaders = this.getDelegates(type);
        return loaders != null && !loaders.isEmpty();
    }

    static String getResourcePackageName(String resource) {
        int i = resource.lastIndexOf(47);
        if (i == -1) {
            return "";
        }
        return resource.substring(0, i).replace('/', '.');
    }

    @Override
    public Loader findLoader(ImportType type, String name) {
        return this.findLoaderInternal(type, name, new URL[1]);
    }

    @Override
    public URL findResource(ImportType type, String name) {
        URL[] result = new URL[1];
        this.findLoaderInternal(type, name, result);
        return result[0];
    }

    private Loader findLoaderInternal(ImportType type, String name, URL[] result) {
        List<? extends DelegateLoader> delegates;
        String pckg;
        List<Loader> loaders;
        Map<String, List<Loader>> map = this.index.get((Object)type);
        if (map != null && !map.isEmpty() && (loaders = map.get(pckg = ClassLoaderInformation.getResourcePackageName(name))) != null && !loaders.isEmpty()) {
            for (Loader loader : loaders) {
                URL url = loader.getResource(name);
                if (url == null) continue;
                result[0] = url;
                this.cacheLoader(name, loader);
                this.cacheResource(name, url);
                return loader;
            }
        }
        if ((delegates = this.getDelegates(type)) != null && !delegates.isEmpty()) {
            for (DelegateLoader delegateLoader : delegates) {
                URL url = delegateLoader.getResource(name);
                if (url == null) continue;
                result[0] = url;
                this.cacheLoader(name, delegateLoader);
                this.cacheResource(name, url);
                return delegateLoader;
            }
        }
        return null;
    }

    @Override
    public String getInfo(ImportType type) {
        StringBuilder builder = new StringBuilder();
        List<? extends DelegateLoader> delegates = this.getDelegates(type);
        if (delegates != null && !delegates.isEmpty()) {
            builder.append("delegates: ").append(delegates);
        }
        builder.append(this.getClassLoader());
        return builder.toString();
    }

    public String toString() {
        return this.policy.toString();
    }
}

