/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management.actions;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;
import org.jboss.profileservice.plugins.management.util.ManagedDeploymentProcessor;
import org.jboss.profileservice.plugins.spi.ProfileViewProcessingContext;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.action.ProfileModificationAction;
import org.jboss.profileservice.spi.action.ProfileModificationContext;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.managed.ManagedProfile;

public class ProfileViewUpdateAction
implements ProfileModificationAction<ProfileModificationContext> {
    static final String DEPLOYMENT_TYPES = KnownDeploymentTypes.class.getName();
    private boolean complete = false;
    private final ManagedProfile managedProfile;
    private final AbstractManagementProxyFactory proxyFactory;
    private final ProfileViewProcessingContext context;

    public ProfileViewUpdateAction(ManagedProfile managedProfile, ProfileViewProcessingContext context, AbstractManagementProxyFactory proxyFactory) {
        this.managedProfile = managedProfile;
        this.context = context;
        this.proxyFactory = proxyFactory;
    }

    public ProfileModificationContext getContext() {
        return null;
    }

    public void complete(ProfileModificationResponse response) {
        ManagedDeploymentProcessor processor = new ManagedDeploymentProcessor(this.proxyFactory);
        Profile profile = this.managedProfile.getProfile();
        for (ProfileDeployment deployment : profile.getDeployments()) {
            try {
                ManagedDeployment md;
                if (deployment.getDeploymentInfo().isDeployed()) {
                    md = this.managedProfile.getManagedDeployment(deployment);
                    processor.processRootManagedDeployment(md, this.context);
                    if (md.getTypes() == null || md.getTypes().isEmpty() || deployment.getTransientAttachments().hasAttachment(DEPLOYMENT_TYPES)) continue;
                    deployment.getTransientAttachments().putAttachment(DEPLOYMENT_TYPES, (Object)md.getTypes());
                    continue;
                }
                md = new ManagedDeploymentImpl(deployment.getName(), deployment.getSimpleName());
                this.updateStoppedDeploymentTypes(deployment, md);
                processor.processManagedDeployment(md, DeploymentState.STOPPED, 0, this.context);
            }
            catch (Exception e) {
                response.setFailure((Throwable)e);
            }
        }
        this.complete = true;
    }

    public void cancel() {
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isComplete() {
        return this.complete;
    }

    protected void updateStoppedDeploymentTypes(ProfileDeployment deployment, ManagedDeployment md) {
        String deploymentName = deployment.getName();
        Collection deploymentTypes = (Collection)deployment.getTransientAttachments().getAttachment(DEPLOYMENT_TYPES, Collection.class);
        if (deploymentTypes != null) {
            md.setTypes(new HashSet(deploymentTypes));
        } else {
            int i = deploymentName.lastIndexOf(".");
            if (i != -1 && i + 1 < deploymentName.length()) {
                String guessedType = deploymentName.substring(i + 1, deploymentName.length());
                if (guessedType.endsWith("/")) {
                    guessedType = guessedType.substring(0, guessedType.length() - 1);
                }
                md.setTypes(new HashSet(1));
                md.addType(guessedType);
            }
        }
    }
}

