/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.plugins.HostThreadLocal;

public class RemoteHostTrustLoginModule
extends UsernamePasswordLoginModule {
    private static final String OPTION_TRUSTED_HOSTS = "trustedHosts";
    private static final String OPTION_ROLES = "roles";
    List<String> trustedHosts;
    private String roleNames;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        boolean trace = this.log.isTraceEnabled();
        String tmp = (String)options.get(OPTION_TRUSTED_HOSTS);
        this.trustedHosts = Arrays.asList(this.parseHosts(tmp));
        this.roleNames = (String)options.get(OPTION_ROLES);
        if (trace) {
            String msg = "roleNames: " + this.roleNames + "\ntrusted hosts {";
            for (String host : this.trustedHosts) {
                msg = msg + "\n" + host;
            }
            msg = msg + "\n}";
            this.log.trace((Object)msg);
        }
    }

    private String[] parseHosts(String commaDel) {
        return commaDel.split("\\,");
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        String host = this.getRealHost();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("real host for trust is " + host));
        }
        if (this.trustedHosts.contains(host)) {
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("real host for trust is " + host));
        }
        return false;
    }

    protected String getUsersPassword() throws LoginException {
        return "trustme";
    }

    protected String getRealHost() {
        return HostThreadLocal.get();
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        if (this.roleNames != null) {
            String[] tokens;
            for (String token : tokens = this.roleNames.split(",")) {
                String roleName = token != null ? token.trim() : token;
                roles.addMember(new SimplePrincipal(roleName));
            }
        }
        return roleSets;
    }
}

