/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderResourceLoader
implements ResourceLoader {
    private WeakReference<ClassLoader> clRef;

    public ClassLoaderResourceLoader(ClassLoader classLoader) {
        this.clRef = new WeakReference<ClassLoader>(classLoader);
    }

    public Class<?> classForName(String name) {
        ClassLoader classLoader = (ClassLoader)this.clRef.get();
        if (classLoader == null) {
            throw new ResourceLoadingException("Error loading class " + name + ", classloader GC-ed.");
        }
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
        catch (TypeNotPresentException e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
    }

    public URL getResource(String name) {
        ClassLoader classLoader = (ClassLoader)this.clRef.get();
        if (classLoader == null) {
            return null;
        }
        return classLoader.getResource(name);
    }

    public Collection<URL> getResources(String name) {
        ClassLoader classLoader = (ClassLoader)this.clRef.get();
        if (classLoader == null) {
            return Collections.emptySet();
        }
        try {
            Enumeration<URL> enumResources = classLoader.getResources(name);
            ArrayList<URL> resources = new ArrayList<URL>();
            while (enumResources.hasMoreElements()) {
                resources.add(enumResources.nextElement());
            }
            return resources;
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Error loading resource " + name, (Throwable)e);
        }
    }

    public void cleanup() {
    }
}

