/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.auth;

import java.security.Principal;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.auth.Authenticator;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnknownUserException;
import org.apache.juddi.util.Config;
import org.jboss.security.AuthenticationManager;

public class JBossAuthenticator
implements Authenticator {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$auth$JBossAuthenticator == null ? (class$org$apache$juddi$auth$JBossAuthenticator = JBossAuthenticator.class$("org.apache.juddi.auth.JBossAuthenticator")) : class$org$apache$juddi$auth$JBossAuthenticator));
    private static final String SECURITY_DOMAIN_KEY = "juddi.securityDomain";
    private static final String DEFAULT_SECURITY_DOMAIN = "java:/jaas/other";
    AuthenticationManager authManager;
    static /* synthetic */ Class class$org$apache$juddi$auth$JBossAuthenticator;

    public JBossAuthenticator() {
        this.init();
    }

    public String authenticate(final String userID, String credential) throws RegistryException {
        if (userID == null) {
            throw new UnknownUserException("Invalid user ID = " + userID);
        }
        Principal principal = new Principal(){

            public String getName() {
                return userID;
            }
        };
        if (!this.authManager.isValid(principal, (Object)credential)) {
            throw new UnknownUserException("Invalid credentials");
        }
        return userID;
    }

    private void init() {
        String securityDomain = Config.getStringProperty(SECURITY_DOMAIN_KEY, DEFAULT_SECURITY_DOMAIN);
        try {
            InitialContext ctx = new InitialContext();
            this.authManager = (AuthenticationManager)ctx.lookup(securityDomain);
            ctx.close();
        }
        catch (NamingException e) {
            log.error((Object)("JNDI Exception looking for autentication manager: " + securityDomain), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

