/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DiscardAuthToken;
import org.apache.juddi.datatype.request.GetAuthToken;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.AuthTokenRequiredException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.function.GetAuthTokenFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class DiscardAuthTokenFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$DiscardAuthTokenFunction == null ? (class$org$apache$juddi$function$DiscardAuthTokenFunction = DiscardAuthTokenFunction.class$("org.apache.juddi.function.DiscardAuthTokenFunction")) : class$org$apache$juddi$function$DiscardAuthTokenFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$DiscardAuthTokenFunction;

    public DiscardAuthTokenFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        DiscardAuthToken request = (DiscardAuthToken)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            String authToken = authInfo.getValue();
            if (authInfo == null || authInfo.getValue() == null) {
                throw new AuthTokenRequiredException("discard_authToken: authInfo=" + authInfo);
            }
            dataStore.retireAuthToken(authToken);
            dataStore.commit();
            log.info((Object)("Publisher '" + publisherID + "' has discarded AuthToken: " + authToken));
        }
        catch (AuthTokenRequiredException authex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)authex.getMessage());
            throw authex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
        Result result = new Result(0);
        result.setErrCode(Result.lookupErrCode(0));
        DispositionReport dispRpt = new DispositionReport();
        dispRpt.setGeneric(generic);
        dispRpt.setOperator(Config.getOperator());
        dispRpt.addResult(result);
        return dispRpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            GetAuthToken getRequest = new GetAuthToken("sviens", "password");
            AuthToken getResponse = (AuthToken)new GetAuthTokenFunction(reg).execute(getRequest);
            DiscardAuthToken discardRequest1 = new DiscardAuthToken(getResponse.getAuthInfo());
            DispositionReport discardResponse = (DispositionReport)new DiscardAuthTokenFunction(reg).execute(discardRequest1);
            System.out.println("errno: " + discardResponse.toString());
            DiscardAuthToken discardRequest2 = new DiscardAuthToken();
            discardRequest2.setAuthInfo(new AuthInfo("**-BadAuthToken-**"));
            DispositionReport discardResponse2 = (DispositionReport)new DiscardAuthTokenFunction(reg).execute(discardRequest2);
            System.out.println("errno: " + discardResponse2.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

