/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.UUID;

public class RouterStubManager
implements RouterStub.ConnectionListener {
    private final Map<InetSocketAddress, Future<?>> futures = new HashMap();
    private final Lock reconnectorLock = new ReentrantLock();
    private final List<RouterStub> stubs;
    private final Protocol owner;
    private final TimeScheduler timer;
    private final String channelName;
    private final Address logicalAddress;
    private final long interval;
    protected final Log log;

    public RouterStubManager(Protocol owner, String channelName, Address logicalAddress, long interval) {
        this.owner = owner;
        this.stubs = new CopyOnWriteArrayList<RouterStub>();
        this.log = LogFactory.getLog(owner.getClass());
        this.timer = owner.getTransport().getTimer();
        this.channelName = channelName;
        this.logicalAddress = logicalAddress;
        this.interval = interval;
    }

    private RouterStubManager(Protocol p) {
        this(p, null, null, 0L);
    }

    public List<RouterStub> getStubs() {
        return this.stubs;
    }

    public RouterStub createAndRegisterStub(String routerHost, int routerPort, InetAddress bindAddress) {
        RouterStub s = new RouterStub(routerHost, routerPort, bindAddress, this);
        this.unregisterAndDestroyStub(s.getGossipRouterAddress());
        this.stubs.add(s);
        return s;
    }

    public void registerStub(RouterStub s) {
        this.unregisterAndDestroyStub(s.getGossipRouterAddress());
        this.stubs.add(s);
    }

    public boolean unregisterStub(RouterStub s) {
        return this.stubs.remove(s);
    }

    public RouterStub unregisterStub(InetSocketAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Cannot remove null address");
        }
        for (RouterStub s : this.stubs) {
            if (!s.getGossipRouterAddress().equals(address)) continue;
            this.stubs.remove(address);
            return s;
        }
        return null;
    }

    public boolean unregisterAndDestroyStub(InetSocketAddress address) {
        RouterStub unregisteredStub = this.unregisterStub(address);
        if (unregisteredStub != null) {
            unregisteredStub.destroy();
            return true;
        }
        return false;
    }

    public void disconnectStubs() {
        for (RouterStub stub : this.stubs) {
            try {
                stub.disconnect(this.channelName, this.logicalAddress);
            }
            catch (Exception exception) {}
        }
    }

    public void destroyStubs() {
        for (RouterStub s : this.stubs) {
            this.stopReconnecting(s);
            s.destroy();
        }
        this.stubs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReconnecting(final RouterStub stub) {
        this.reconnectorLock.lock();
        try {
            InetSocketAddress routerAddress = stub.getGossipRouterAddress();
            Future<?> f = this.futures.get(routerAddress);
            if (f != null) {
                f.cancel(true);
                this.futures.remove(routerAddress);
            }
            Runnable reconnector = new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            if (RouterStubManager.this.log.isTraceEnabled()) {
                                RouterStubManager.this.log.trace("Reconnecting " + stub);
                            }
                            String logical_name = UUID.get(RouterStubManager.this.logicalAddress);
                            PhysicalAddress physical_addr = (PhysicalAddress)RouterStubManager.this.owner.down(new Event(87, RouterStubManager.this.logicalAddress));
                            List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
                            stub.connect(RouterStubManager.this.channelName, RouterStubManager.this.logicalAddress, logical_name, physical_addrs);
                            if (RouterStubManager.this.log.isTraceEnabled()) {
                                RouterStubManager.this.log.trace("Reconnected " + stub);
                            }
                        }
                        catch (Throwable ex) {
                            if (!RouterStubManager.this.log.isWarnEnabled()) break block4;
                            RouterStubManager.this.log.warn("failed reconnecting stub to GR at " + stub.getGossipRouterAddress() + ": " + ex);
                        }
                    }
                }
            };
            f = this.timer.scheduleWithFixedDelay(reconnector, 0L, this.interval, TimeUnit.MILLISECONDS);
            this.futures.put(stub.getGossipRouterAddress(), f);
        }
        finally {
            this.reconnectorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReconnecting(final RouterStub stub) {
        this.reconnectorLock.lock();
        try {
            InetSocketAddress routerAddress = stub.getGossipRouterAddress();
            Future<?> f = this.futures.get(stub.getGossipRouterAddress());
            if (f != null) {
                f.cancel(true);
                this.futures.remove(routerAddress);
            }
            Runnable pinger = new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            if (RouterStubManager.this.log.isTraceEnabled()) {
                                RouterStubManager.this.log.trace("Pinging " + stub);
                            }
                            stub.checkConnection();
                            if (RouterStubManager.this.log.isTraceEnabled()) {
                                RouterStubManager.this.log.trace("Pinged " + stub);
                            }
                        }
                        catch (Throwable ex) {
                            if (!RouterStubManager.this.log.isWarnEnabled()) break block4;
                            RouterStubManager.this.log.warn("failed pinging stub, GR at " + stub.getGossipRouterAddress() + ": " + ex);
                        }
                    }
                }
            };
            f = this.timer.scheduleWithFixedDelay(pinger, 0L, this.interval, TimeUnit.MILLISECONDS);
            this.futures.put(stub.getGossipRouterAddress(), f);
        }
        finally {
            this.reconnectorLock.unlock();
        }
    }

    @Override
    public void connectionStatusChange(RouterStub stub, RouterStub.ConnectionStatus newState) {
        if (newState == RouterStub.ConnectionStatus.CONNECTION_BROKEN) {
            stub.interrupt();
            stub.destroy();
            this.startReconnecting(stub);
        } else if (newState == RouterStub.ConnectionStatus.CONNECTED) {
            this.stopReconnecting(stub);
        } else if (newState == RouterStub.ConnectionStatus.DISCONNECTED) {
            try {
                stub.join(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static RouterStubManager emptyGossipClientStubManager(Protocol p) {
        return new RouterStubManager(p);
    }
}

