/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.jgroups.Address;
import org.jgroups.blocks.AbstractConnectionMap;
import org.jgroups.blocks.TCPConnectionMap;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Util;

public class ConnectionMapDemo
implements TCPConnectionMap.Receiver,
AbstractConnectionMap.ConnectionMapListener<TCPConnectionMap.TCPConnection> {
    TCPConnectionMap ct = null;
    String dst_host = null;
    int dst_port = 0;

    @Override
    public void receive(Address sender, byte[] data, int offset, int length) {
        String s = new String(data, offset, length);
        System.out.println("<-- " + s + " (from " + sender + ')');
    }

    @Override
    public void connectionOpened(Address peer_addr, TCPConnectionMap.TCPConnection conn) {
        System.out.println("** Connection to " + peer_addr + " opened");
    }

    @Override
    public void connectionClosed(Address peer_addr) {
        System.out.println("** Connection to " + peer_addr + " closed");
    }

    public void start(int local_port, String dst_host, int dst_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.ct = reaper_interval > 0L || conn_expire_time > 0L ? new TCPConnectionMap("TCPConnectionMap", new DefaultThreadFactory(Util.getGlobalThreadGroup(), "test", true), this, null, null, local_port, local_port, reaper_interval, conn_expire_time) : new TCPConnectionMap("TCPConnectionMap", new DefaultThreadFactory(Util.getGlobalThreadGroup(), "test", true), null, this, null, null, local_port, local_port);
        this.ct.addConnectionMapListener(this);
        this.ct.start();
        this.dst_host = dst_host;
        this.dst_port = dst_port;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    System.out.print("> ");
                    System.out.flush();
                    String line = in.readLine();
                    if (line.startsWith("quit".toLowerCase()) || line.startsWith("exit".toLowerCase())) break block2;
                    if (line.startsWith("conns")) {
                        System.out.println(this.ct);
                        continue;
                    }
                    IpAddress dest = new IpAddress(dst_host, dst_port);
                    byte[] data = line.getBytes();
                    this.ct.send(dest, data, 0, data.length);
                }
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
        this.ct.stop();
    }

    public static void main(String[] args) {
        String host = "localhost";
        int port = 6666;
        int local_port = 5555;
        long reaper_interval = 0L;
        long conn_expire_time = 0L;
        for (int i = 0; i < args.length; ++i) {
            String tmp = args[i];
            if ("-local_port".equals(tmp)) {
                local_port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-remote_host".equals(tmp)) {
                host = args[++i];
                continue;
            }
            if ("-remote_port".equals(tmp)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-reaper_interval".equals(tmp)) {
                reaper_interval = Long.parseLong(args[++i]);
                continue;
            }
            if ("-conn_expire_time".equals(tmp)) {
                conn_expire_time = Long.parseLong(args[++i]);
                continue;
            }
            ConnectionMapDemo.help();
            return;
        }
        try {
            if (reaper_interval > 0L || conn_expire_time > 0L) {
                if (reaper_interval <= 0L) {
                    reaper_interval = 60000L;
                }
                if (conn_expire_time <= 0L) {
                    conn_expire_time = 300000L;
                }
                new ConnectionMapDemo().start(local_port, host, port, reaper_interval, conn_expire_time);
            } else {
                new ConnectionMapDemo().start(local_port, host, port, 0L, 0L);
            }
        }
        catch (Exception ex) {
            System.err.println("ConnectionMapDemo.main(): " + ex);
        }
    }

    static void help() {
        System.out.println("ConnectionMapDemo [-help] [-local_port <port>] [-remote_host <host>] [-remote_port <port>] [-reaper_interval <interval (msecs)>] [-conn_expire_time <time (msecs)>]");
    }
}

