/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.StackType;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ProtocolConfigurationTest {
    ProtocolStack stack = null;
    Protocol protocol = null;
    static final String orderProps = "org.jgroups.tests.ProtocolConfigurationTest$ORDERING(a=1;b=2;c=3)";
    static final String refsProps = "org.jgroups.tests.ProtocolConfigurationTest$REFS(a=1;b=2;c=3)";
    static final String defaultProps = "org.jgroups.tests.ProtocolConfigurationTest$DEFAULTS(b=333)";
    static final String addressProps = "org.jgroups.tests.ProtocolConfigurationTest$INETADDRESSES(inetAddressField=127.0.0.1;inet_address_method=192.168.0.100;ipAddressListField=127.0.0.1[8080],127.0.0.1[8081];ip_address_list_method=192.168.0.100[5678],192.168.0.101[2345];port_range=1)";
    static final String configurableObjectsProps = "org.jgroups.tests.ProtocolConfigurationTest$CONFIGOBJPROTOCOL(config_object_class=org.jgroups.tests.ProtocolConfigurationTest$ConfigurableObject;string_property=test)";
    List<String> order = new LinkedList<String>();

    @BeforeMethod
    void setUp() {
        this.stack = new ProtocolStack();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testResolutionOfDependencies() throws Exception {
        try {
            this.protocol = Configurator.createProtocol(refsProps, this.stack);
        }
        catch (IllegalArgumentException e) {
            System.out.println("exception thrown (expected): " + e.getMessage());
            throw e;
        }
    }

    public void testDependencyOrdering() throws Exception {
        LinkedList<String> correctOrder = new LinkedList<String>();
        correctOrder.add("c");
        correctOrder.add("b");
        correctOrder.add("a");
        this.protocol = Configurator.createProtocol(orderProps, this.stack);
        List<String> actualOrder = ((ORDERING)this.protocol).getList();
        assert (((Object)actualOrder).equals(correctOrder));
    }

    public void testDefaultAssignment() throws Exception {
        Vector<ProtocolConfiguration> protocol_configs = new Vector<ProtocolConfiguration>();
        Vector<Protocol> protocols = new Vector<Protocol>();
        this.protocol = Configurator.createProtocol(defaultProps, this.stack);
        protocol_configs.add(new ProtocolConfiguration(defaultProps));
        protocols.add(this.protocol);
        Configurator.setDefaultValues(protocol_configs, protocols, StackType.IPv4);
        int a = ((DEFAULTS)this.protocol).getA();
        System.out.println("value of a = " + a);
        int b = ((DEFAULTS)this.protocol).getB();
        System.out.println("value of b = " + b);
        if (b != 333) {
            throw new RuntimeException("default property value set when it should not have been");
        }
        InetAddress c = ((DEFAULTS)this.protocol).getC();
        System.out.println("value of c = " + c);
        assert (c != null);
    }

    public void testAssignmentInetAddresses() throws Exception {
        Vector protocol_configs = new Vector();
        Vector protocols = new Vector();
        this.protocol = Configurator.createProtocol(addressProps, this.stack);
        InetAddress a = ((INETADDRESSES)this.protocol).getInetAddressField();
        System.out.println("value of inetAddressField = " + a);
        InetAddress b = ((INETADDRESSES)this.protocol).getInetAddressMethod();
        System.out.println("value of inetAddressMethod = " + b);
        List<IpAddress> c = ((INETADDRESSES)this.protocol).getIpAddressListField();
        System.out.println("value of ipAddressListField = " + c);
        List<IpAddress> d = ((INETADDRESSES)this.protocol).getIpAddressListMethod();
        System.out.println("value of ipAddressListMethod = " + d);
    }

    public void testConfigurableObject() throws Exception {
        Vector<ProtocolConfiguration> protocol_configs = new Vector<ProtocolConfiguration>();
        Vector<Protocol> protocols = new Vector<Protocol>();
        this.protocol = Configurator.createProtocol(configurableObjectsProps, this.stack);
        protocol_configs.add(new ProtocolConfiguration(configurableObjectsProps));
        protocols.add(this.protocol);
        List<Object> configObjs = ((CONFIGOBJPROTOCOL)this.protocol).getConfigurableObjects();
        assert (configObjs.size() == 1);
        Object configObj = configObjs.get(0);
        assert (configObj instanceof ConfigurableObject);
        assert (((ConfigurableObject)configObj).getStringProp().equals("test"));
    }

    public static class ConfigurableObject {
        @Property(name="string_property")
        String stringProp = null;

        public String getStringProp() {
            return this.stringProp;
        }

        public void setStringProp(String s) {
            this.stringProp = s;
        }
    }

    public static class CONFIGOBJPROTOCOL
    extends Protocol {
        private Object configObjInstance = null;

        @Property(name="config_object_class")
        public void setConfigurableObjectClass(String class_name) throws Exception {
            this.configObjInstance = Class.forName(class_name).newInstance();
        }

        @Override
        protected List<Object> getConfigurableObjects() {
            LinkedList<Object> retval = new LinkedList<Object>();
            if (this.configObjInstance != null) {
                retval.add(this.configObjInstance);
            }
            return retval;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object down(Event evt) {
            return this.down_prot.down(evt);
        }

        @Override
        public Object up(Event evt) {
            return this.up_prot.up(evt);
        }
    }

    public static class INETADDRESSES
    extends Protocol {
        InetAddress inetAddressMethod;
        @Property(name="inetAddressField")
        InetAddress inetAddressField;
        @Property(description="fred")
        int port_range = 0;
        List<IpAddress> ipAddressListMethod;
        @Property(name="ipAddressListField", converter=PropertyConverters.InitialHosts.class)
        List<IpAddress> ipAddressListField;

        public InetAddress getInetAddressField() {
            return this.inetAddressField;
        }

        @Property(name="inetAddressMethod")
        public void setInetAddressMethod(InetAddress ia) {
            this.inetAddressMethod = ia;
        }

        public InetAddress getInetAddressMethod() {
            return this.inetAddressMethod;
        }

        public List<IpAddress> getIpAddressListField() {
            return this.ipAddressListField;
        }

        @Property(name="ipAddressListMethod", converter=PropertyConverters.InitialHosts.class, dependsUpon="port_range")
        public void setIpAddressListMethod(List<IpAddress> ia) {
            this.ipAddressListMethod = ia;
        }

        public List<IpAddress> getIpAddressListMethod() {
            return this.ipAddressListMethod;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object down(Event evt) {
            return this.down_prot.down(evt);
        }

        @Override
        public Object up(Event evt) {
            return this.up_prot.up(evt);
        }
    }

    public static class DEFAULTS
    extends Protocol {
        int a;
        int b;
        InetAddress c;

        @Property(name="a")
        public void setA(int a) {
            this.a = a;
        }

        @Property(name="b")
        public void setB(int b) {
            this.b = b;
        }

        @Property(name="c", defaultValueIPv4="192.168.1.10")
        public void setC(InetAddress ia) {
            this.c = ia;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public InetAddress getC() {
            return this.c;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object down(Event evt) {
            return this.down_prot.down(evt);
        }

        @Override
        public Object up(Event evt) {
            return this.up_prot.up(evt);
        }
    }

    public static class REFS
    extends Protocol {
        @Property(name="a", dependsUpon="b")
        public void setA(int a) {
        }

        @Property(name="b", dependsUpon="d")
        public void setB(int b) {
        }

        @Property(name="c")
        public void setC(int c) {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object down(Event evt) {
            return this.down_prot.down(evt);
        }

        @Override
        public Object up(Event evt) {
            return this.up_prot.up(evt);
        }
    }

    public static class ORDERING
    extends Protocol {
        List<String> list = new LinkedList<String>();

        @Property(name="a", dependsUpon="b")
        public void setA(int a) {
            this.list.add("a");
        }

        @Property(name="b", dependsUpon="c")
        public void setB(int b) {
            this.list.add("b");
        }

        @Property(name="c")
        public void setC(int c) {
            this.list.add("c");
        }

        List<String> getList() {
            return this.list;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object down(Event evt) {
            return this.down_prot.down(evt);
        }

        @Override
        public Object up(Event evt) {
            return this.up_prot.up(evt);
        }
    }
}

